/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust;

public enum ServiceTypeIdentifier {
    CA_QC("CA/QC", "http://uri.etsi.org/TrstSvc/Svctype/CA/QC", true, false),
    OCSP_QC("OCSP/QC", "http://uri.etsi.org/TrstSvc/Svctype/Certstatus/OCSP/QC", true, false),
    CRL_QC("CRL/QC", "http://uri.etsi.org/TrstSvc/Svctype/Certstatus/CRL/QC", true, false),
    TSA_QTST("TSA/QTST", "http://uri.etsi.org/TrstSvc/Svctype/TSA/QTST", true, false),
    EDS_Q("EDS/Q", "http://uri.etsi.org/TrstSvc/Svctype/EDS/Q", true, false),
    EDS_REM_Q("EDS/REM/Q", "http://uri.etsi.org/TrstSvc/Svctype/EDS/REM/Q", true, false),
    PSES_Q("PSES/Q", "http://uri.etsi.org/TrstSvc/Svctype/PSES/Q", true, false),
    QESVALIDATION_Q("QESValidation/Q", "http://uri.etsi.org/TrstSvc/Svctype/QESValidation/Q", true, false),
    CA_PKC("CA/PKC", "http://uri.etsi.org/TrstSvc/Svctype/CA/PKC", false, false),
    OCSP("OCSP", "http://uri.etsi.org/TrstSvc/Svctype/Certstatus/OCSP", false, false),
    CRL("CRL", "http://uri.etsi.org/TrstSvc/Svctype/Certstatus/CRL", false, false),
    TSA("TSA", "http://uri.etsi.org/TrstSvc/Svctype/TSA", false, false),
    TSA_TSS_QC("TSA/TSS-QC", "http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-QC", false, false),
    TSA_TSS_ADESQC_AND_QES("TSA/TSS-AdESQCandQES", "http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-AdESQCandQES", false, false),
    EDS("EDS", "http://uri.etsi.org/TrstSvc/Svctype/EDS", false, false),
    EDS_REM("EDS/REM", "http://uri.etsi.org/TrstSvc/Svctype/EDS/REM", false, false),
    PSES("PSES", "http://uri.etsi.org/TrstSvc/Svctype/PSES", false, false),
    ADES_VALIDATION("AdESValidation", "http://uri.etsi.org/TrstSvc/Svctype/AdESValidation", false, false),
    ADES_GENERATION("AdESGeneration", "http://uri.etsi.org/TrstSvc/Svctype/AdESGeneration", false, false),
    RA("RA", "http://uri.etsi.org/TrstSvc/Svctype/RA", false, true),
    RA_NOTHAVINGPKIID("RA/nothavingPKIid", "http://uri.etsi.org/TrstSvc/Svctype/RA/nothavingPKIid", false, true),
    ACA("ACA", "http://uri.etsi.org/TrstSvc/Svctype/ACA", false, true),
    SIGNATUREPOLICYAUTHORITY("SignaturePolicyAuthority", "http://uri.etsi.org/TrstSvc/Svctype/SignaturePolicyAuthority", false, true),
    ARCHIV("Archiv", "http://uri.etsi.org/TrstSvc/Svctype/Archiv", false, true),
    ARCHIV_NOTHAVINGPKIID("Archiv/nothavingPKIid", "http://uri.etsi.org/TrstSvc/Svctype/Archiv/nothavingPKIid", false, true),
    IDV("IdV", "http://uri.etsi.org/TrstSvc/Svctype/IdV", false, true),
    IDV_NOTHAVINGPKIID("IdV/nothavingPKIid", "http://uri.etsi.org/TrstSvc/Svctype/IdV/nothavingPKIid", false, true),
    KESCROW("KEscrow", "http://uri.etsi.org/TrstSvc/Svctype/KEscrow", false, true),
    KESCROW_NOTHAVINGPKIID("KEscrow/nothavingPKIid", "http://uri.etsi.org/TrstSvc/Svctype/KEscrow/nothavingPKIid", false, true),
    PPWD("PPwd", "http://uri.etsi.org/TrstSvc/Svctype/PPwd", false, true),
    PPWD_NOTHAVINGPKIID("PPwd/nothavingPKIid", "http://uri.etsi.org/TrstSvc/Svctype/PPwd/nothavingPKIid", false, true),
    TLISSUER("TLIssuer", "http://uri.etsi.org/TrstSvd/Svctype/TLIssuer", false, true),
    NATIONALROOTCA_QC("NationalRootCA-QC", "http://uri.etsi.org/TrstSvc/Svctype/NationalRootCA-QC", false, true),
    UNSPECIFIED("unspecified", "http://uri.etsi.org/TrstSvc/Svctype/unspecified", false, true);

    private final String shortName;
    private final String uri;
    private final boolean qualified;
    private final boolean national;

    private ServiceTypeIdentifier(String shortName, String uri, boolean qualified, boolean national) {
        this.shortName = shortName;
        this.uri = uri;
        this.qualified = qualified;
        this.national = national;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public boolean isNational() {
        return this.national;
    }

    public static boolean isCaQc(String serviceTypeIdentifier) {
        return CA_QC.getUri().equals(serviceTypeIdentifier);
    }

    public static boolean isQTST(String serviceTypeIdentifier) {
        return TSA_QTST.getUri().equals(serviceTypeIdentifier);
    }

    public static ServiceTypeIdentifier fromUri(String uri) {
        for (ServiceTypeIdentifier sti : ServiceTypeIdentifier.values()) {
            if (!sti.getUri().equals(uri)) continue;
            return sti;
        }
        return null;
    }
}

