/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.GrantedServiceFilter;
import java.util.Collection;
import java.util.List;

class QualificationByTL
implements QualificationStrategy {
    private final TrustServiceWrapper trustService;
    private final QualificationStrategy qualifiedInCert;

    public QualificationByTL(TrustServiceWrapper trustService, QualificationStrategy qualifiedInCert) {
        this.trustService = trustService;
        this.qualifiedInCert = qualifiedInCert;
    }

    @Override
    public CertificateQualifiedStatus getQualifiedStatus() {
        if (this.trustService == null) {
            return CertificateQualifiedStatus.NOT_QC;
        }
        GrantedServiceFilter grantedFilter = new GrantedServiceFilter();
        if (!grantedFilter.isAcceptable(this.trustService)) {
            return CertificateQualifiedStatus.NOT_QC;
        }
        List capturedQualifiers = this.trustService.getCapturedQualifierUris();
        if (Utils.isCollectionNotEmpty((Collection)capturedQualifiers)) {
            if (ServiceQualification.isNotQualified((List)capturedQualifiers)) {
                return CertificateQualifiedStatus.NOT_QC;
            }
            if (ServiceQualification.isQcStatement((List)capturedQualifiers)) {
                return CertificateQualifiedStatus.QC;
            }
        }
        return this.qualifiedInCert.getQualifiedStatus();
    }
}

