/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.enumerations.QSCDStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationMatrix;

public class FinalCertificateQualificationCalculator {
    private final CertificateQualification certQualificationAtIssuanceTime;
    private final CertificateQualification certQualificationAtBestSignatureTime;

    public FinalCertificateQualificationCalculator(CertificateQualification certQualificationAtIssuanceTime, CertificateQualification certQualificationAtBestSignatureTime) {
        this.certQualificationAtIssuanceTime = certQualificationAtIssuanceTime;
        this.certQualificationAtBestSignatureTime = certQualificationAtBestSignatureTime;
    }

    public CertificateQualification getFinalQualification() {
        if (this.certQualificationAtIssuanceTime == this.certQualificationAtBestSignatureTime) {
            return this.certQualificationAtIssuanceTime;
        }
        if (CertificateQualification.NA.equals((Object)this.certQualificationAtIssuanceTime) || CertificateQualification.NA.equals((Object)this.certQualificationAtBestSignatureTime)) {
            return CertificateQualification.NA;
        }
        CertificateQualifiedStatus qualStatus = this.getFinalCertQualStatus();
        CertificateType type = this.getFinalCertificateType();
        QSCDStatus qscd = this.getFinalQSCDStatus();
        return CertQualificationMatrix.getCertQualification(qualStatus, type, qscd);
    }

    private CertificateQualifiedStatus getFinalCertQualStatus() {
        return this.certQualificationAtIssuanceTime.isQc() && this.certQualificationAtBestSignatureTime.isQc() ? CertificateQualifiedStatus.QC : CertificateQualifiedStatus.NOT_QC;
    }

    private CertificateType getFinalCertificateType() {
        if (this.certQualificationAtIssuanceTime.getType() == this.certQualificationAtBestSignatureTime.getType()) {
            return this.certQualificationAtBestSignatureTime.getType();
        }
        return CertificateType.UNKNOWN;
    }

    private QSCDStatus getFinalQSCDStatus() {
        return this.certQualificationAtBestSignatureTime.isQscd() ? QSCDStatus.QSCD : QSCDStatus.NOT_QSCD;
    }
}

