/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampAnalyzer;
import eu.europa.esig.dss.validation.timestamp.TimestampValidator;
import java.util.List;

public class DetachedTimestampValidator
extends SignedDocumentValidator
implements TimestampValidator {
    DetachedTimestampValidator() {
        this(new DetachedTimestampAnalyzer());
    }

    protected DetachedTimestampValidator(DetachedTimestampAnalyzer detachedTimestampAnalyzer) {
        super((DocumentAnalyzer)detachedTimestampAnalyzer);
    }

    public DetachedTimestampValidator(DSSDocument timestampFile) {
        super((DocumentAnalyzer)new DetachedTimestampAnalyzer(timestampFile));
    }

    public DetachedTimestampValidator(DSSDocument timestampFile, TimestampType timestampType) {
        super((DocumentAnalyzer)new DetachedTimestampAnalyzer(timestampFile, timestampType));
    }

    public DetachedTimestampAnalyzer getDocumentAnalyzer() {
        return (DetachedTimestampAnalyzer)super.getDocumentAnalyzer();
    }

    @Override
    public TimestampToken getTimestamp() {
        return this.getDocumentAnalyzer().getTimestamp();
    }

    public void setTimestampedData(DSSDocument document) {
        this.getDocumentAnalyzer().setTimestampedData(document);
    }

    @Override
    public DSSDocument getTimestampedData() {
        return this.getDocumentAnalyzer().getTimestampedData();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        throw new UnsupportedOperationException("getOriginalDocuments(signatureId) is not supported for DetachedTimestampValidator!");
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        throw new UnsupportedOperationException("getOriginalDocuments(AdvancedSignature) is not supported for DetachedTimestampValidator!");
    }
}

