/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.ValidationLevel;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.EvidenceRecordTimestampsValidationBlock;
import eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.EvidenceRecordValidationProcess;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvidenceRecordsValidationBlock {
    private final I18nProvider i18nProvider;
    private final DiagnosticData diagnosticData;
    protected final ValidationPolicy policy;
    protected final Date currentTime;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final List<XmlTLAnalysis> tlAnalysis;
    private final ValidationLevel validationLevel;
    private final POEExtraction poe;
    private final Map<String, XmlTimestamp> timestampValidations = new HashMap<String, XmlTimestamp>();
    private final Map<String, XmlEvidenceRecord> evidenceRecordValidations = new HashMap<String, XmlEvidenceRecord>();

    public EvidenceRecordsValidationBlock(I18nProvider i18nProvider, DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, Map<String, XmlBasicBuildingBlocks> bbbs, List<XmlTLAnalysis> tlAnalysis, ValidationLevel validationLevel, POEExtraction poe) {
        this.i18nProvider = i18nProvider;
        this.diagnosticData = diagnosticData;
        this.policy = policy;
        this.currentTime = currentTime;
        this.bbbs = bbbs;
        this.tlAnalysis = tlAnalysis;
        this.validationLevel = validationLevel;
        this.poe = poe;
    }

    public void execute() {
        for (EvidenceRecordWrapper evidenceRecord : this.diagnosticData.getEvidenceRecords()) {
            XmlEvidenceRecord evidenceRecordAnalysis = new XmlEvidenceRecord();
            evidenceRecordAnalysis.setId(evidenceRecord.getId());
            EvidenceRecordTimestampsValidationBlock allTimestampValidationBlock = new EvidenceRecordTimestampsValidationBlock(this.i18nProvider, evidenceRecord, this.diagnosticData, this.policy, this.currentTime, this.bbbs, this.tlAnalysis, this.validationLevel);
            Map<String, XmlTimestamp> currentTimestampValidations = allTimestampValidationBlock.execute();
            this.timestampValidations.putAll(currentTimestampValidations);
            evidenceRecordAnalysis.getTimestamps().addAll(currentTimestampValidations.values());
            EvidenceRecordValidationProcess ervp = new EvidenceRecordValidationProcess(this.i18nProvider, evidenceRecord, currentTimestampValidations.values(), this.bbbs, this.policy, this.currentTime);
            XmlValidationProcessEvidenceRecord validationProcessEvidenceRecord = (XmlValidationProcessEvidenceRecord)ervp.execute();
            evidenceRecordAnalysis.setValidationProcessEvidenceRecord(validationProcessEvidenceRecord);
            XmlConclusion conclusion = validationProcessEvidenceRecord.getConclusion();
            evidenceRecordAnalysis.setConclusion(conclusion);
            if (conclusion != null && Indication.PASSED == conclusion.getIndication()) {
                this.poe.extractPOE(evidenceRecord);
            }
            this.evidenceRecordValidations.put(evidenceRecord.getId(), evidenceRecordAnalysis);
        }
    }

    public Map<String, XmlTimestamp> getTimestampValidations() {
        return this.timestampValidations;
    }

    public Map<String, XmlEvidenceRecord> getEvidenceRecordValidations() {
        return this.evidenceRecordValidations;
    }
}

