/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationIssuerTrustedCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.LongTermValidationCertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POEExistsWithinCertificateValidityRangeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastValidationAcceptableRevocationDataAvailable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PastSignatureValidationCertificateRevocationSelector
extends LongTermValidationCertificateRevocationSelector {
    private final POEExtraction poe;
    private final List<CertificateRevocationWrapper> acceptableCertificateRevocations = new ArrayList<CertificateRevocationWrapper>();

    public PastSignatureValidationCertificateRevocationSelector(I18nProvider i18nProvider, CertificateWrapper certificate, Date currentTime, Map<String, XmlBasicBuildingBlocks> bbbs, String tokenId, POEExtraction poe, ValidationPolicy validationPolicy) {
        super(i18nProvider, certificate, currentTime, bbbs, tokenId, validationPolicy);
        this.poe = poe;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.PSV_CRS;
    }

    @Override
    protected ChainItem<XmlCRS> verifyRevocationData(ChainItem<XmlCRS> item, CertificateRevocationWrapper revocationWrapper) {
        CertificateWrapper revocationIssuer;
        item = super.verifyRevocationData(item, revocationWrapper);
        Boolean validity = (Boolean)this.revocationDataValidityMap.get(revocationWrapper);
        if (Boolean.TRUE.equals(validity) && (revocationIssuer = revocationWrapper.getSigningCertificate()) != null) {
            if (revocationIssuer.isTrusted()) {
                item = item.setNextItem(this.revocationDataIssuerTrusted(revocationIssuer));
                this.acceptableCertificateRevocations.add(revocationWrapper);
                ((XmlCRS)this.result).getAcceptableRevocationId().add(revocationWrapper.getId());
                this.revocationDataValidityMap.put(revocationWrapper, true);
            } else {
                item = item.setNextItem(this.poeForRevocationDataIssuerExists(revocationIssuer));
                validity = this.poe.isPOEExistInRange(revocationIssuer.getId(), revocationIssuer.getNotBefore(), revocationIssuer.getNotAfter());
                if (Boolean.TRUE.equals(validity)) {
                    this.acceptableCertificateRevocations.add(revocationWrapper);
                    ((XmlCRS)this.result).getAcceptableRevocationId().add(revocationWrapper.getId());
                }
                this.revocationDataValidityMap.put(revocationWrapper, validity);
            }
        }
        return item;
    }

    @Override
    protected XmlConclusion getRevocationBBBConclusion(CertificateRevocationWrapper revocationWrapper) {
        XmlBasicBuildingBlocks revocationBBB = (XmlBasicBuildingBlocks)this.bbbs.get(revocationWrapper.getId());
        if (revocationBBB != null) {
            return revocationBBB.getConclusion();
        }
        return null;
    }

    private ChainItem<XmlCRS> revocationDataIssuerTrusted(CertificateWrapper revocationIssuer) {
        return new RevocationIssuerTrustedCheck<XmlCRS>(this.i18nProvider, (XmlCRS)this.result, revocationIssuer, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlCRS> poeForRevocationDataIssuerExists(CertificateWrapper revocationIssuer) {
        return new POEExistsWithinCertificateValidityRangeCheck<XmlCRS>(this.i18nProvider, (XmlCRS)this.result, revocationIssuer, this.poe, this.getWarnLevelConstraint());
    }

    @Override
    protected ChainItem<XmlCRS> acceptableRevocationDataAvailable() {
        return new PastValidationAcceptableRevocationDataAvailable<XmlCRS>(this.i18nProvider, (XmlCRS)this.result, this.acceptableCertificateRevocations, this.getFailLevelConstraint());
    }

    public List<CertificateRevocationWrapper> getAcceptableCertificateRevocations() {
        return this.acceptableCertificateRevocations;
    }
}

