/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LongTermAvailabilityAndIntegrityValidationMaterialCheck
extends ChainItem<XmlValidationProcessArchivalData> {
    private final SignatureWrapper signature;
    private final XmlConstraintsConclusion longTermValidationResult;
    private Indication ltvIndication;
    private SubIndication ltvSubIndication;

    public LongTermAvailabilityAndIntegrityValidationMaterialCheck(I18nProvider i18nProvider, XmlValidationProcessArchivalData result, SignatureWrapper signature, XmlConstraintsConclusion longTermValidationResult, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
        this.longTermValidationResult = longTermValidationResult;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.LTA;
    }

    @Override
    protected boolean process() {
        if (this.longTermValidationResult != null && this.longTermValidationResult.getConclusion() != null) {
            this.ltvIndication = this.longTermValidationResult.getConclusion().getIndication();
            this.ltvSubIndication = this.longTermValidationResult.getConclusion().getSubIndication();
        }
        return ValidationProcessUtils.isLongTermAvailabilityAndIntegrityMaterialPresent(this.signature);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ARCH_LTAIVMP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ARCH_LTAIVMP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.ltvIndication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.ltvSubIndication;
    }

    @Override
    protected List<XmlMessage> getPreviousErrors() {
        if (this.longTermValidationResult != null && this.longTermValidationResult.getConclusion() != null) {
            ArrayList<XmlMessage> errors = new ArrayList<XmlMessage>(this.longTermValidationResult.getConclusion().getErrors());
            if (Utils.isCollectionNotEmpty(errors)) {
                errors.add(this.buildErrorMessage());
            }
            return errors;
        }
        return Collections.emptyList();
    }
}

