/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class CertificateKnownToBeNotRevokedCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificate;
    private final CertificateRevocationWrapper revocationData;
    private final Date currentTime;
    private final XmlConclusion bsConclusion;

    public CertificateKnownToBeNotRevokedCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, CertificateRevocationWrapper revocationData, Date currentTime, XmlConclusion bsConclusion, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, certificate.getId());
        this.certificate = certificate;
        this.revocationData = revocationData;
        this.currentTime = currentTime;
        this.bsConclusion = bsConclusion;
    }

    @Override
    protected boolean process() {
        return false;
    }

    private boolean isInValidityRange(CertificateWrapper certificateWrapper) {
        Date notBefore = certificateWrapper.getNotBefore();
        Date notAfter = certificateWrapper.getNotAfter();
        return notBefore != null && this.currentTime.compareTo(notBefore) >= 0 && notAfter != null && this.currentTime.compareTo(notAfter) <= 0;
    }

    private boolean isRevocationIssuerValid(CertificateWrapper revocationDataIssuer) {
        return revocationDataIssuer.isTrusted() || this.isInValidityRange(this.revocationData.getSigningCertificate());
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.revocationData != null && !this.revocationData.isRevoked() && this.revocationData.getSigningCertificate() != null && !this.isRevocationIssuerValid(this.revocationData.getSigningCertificate())) {
            CertificateWrapper revocationIssuer = this.revocationData.getSigningCertificate();
            String notBeforeStr = revocationIssuer.getNotBefore() == null ? " ? " : ValidationProcessUtils.getFormattedDate(revocationIssuer.getNotBefore());
            String notAfterStr = revocationIssuer.getNotAfter() == null ? " ? " : ValidationProcessUtils.getFormattedDate(revocationIssuer.getNotAfter());
            String validationTime = ValidationProcessUtils.getFormattedDate(this.currentTime);
            return this.i18nProvider.getMessage(MessageTag.REVOCATION_CERT_VALIDITY, new Object[]{revocationIssuer.getId(), this.revocationData.getId(), notBeforeStr, notAfterStr, validationTime});
        }
        return this.i18nProvider.getMessage(MessageTag.TOKEN_ID, new Object[]{this.certificate.getId()});
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.bsConclusion.getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.bsConclusion.getSubIndication();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.LTV_ISCKNR;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        if (this.revocationData != null && !this.revocationData.isRevoked() && this.revocationData.getSigningCertificate() != null && !this.isRevocationIssuerValid(this.revocationData.getSigningCertificate())) {
            return MessageTag.LTV_ISCKNR_ANS1;
        }
        return MessageTag.LTV_ISCKNR_ANS0;
    }
}

