/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DigestCryptographicCheckerResultCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class SigningCertificateRefDigestCryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends DigestCryptographicCheckerResultCheck<T> {
    private final CertificateRefWrapper certificateRefWrapper;
    private final LevelConstraint constraint;

    public SigningCertificateRefDigestCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, Date validationDate, CertificateRefWrapper certificateRefWrapper, XmlCC ccResult, LevelConstraint constraint) {
        super(i18nProvider, result, validationDate, MessageTag.ACCM_POS_SIG_CERT_REF, ccResult, constraint);
        this.certificateRefWrapper = certificateRefWrapper;
        this.constraint = constraint;
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (this.isValid((XmlConstraintsConclusion)this.ccResult)) {
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_DM_WITH_ID, new Object[]{this.ccResult.getVerifiedAlgorithm().getName(), dateTime, this.position, this.certificateRefWrapper.getCertificateId()});
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_ID, new Object[]{this.getErrorMessage(), dateTime, this.position, this.certificateRefWrapper.getCertificateId()});
    }

    @Override
    protected Level getLevel() {
        if (this.constraint != null) {
            Level currentConstraintLevel = this.constraint.getLevel();
            Level subProcessLevel = this.getSubProcessLevel();
            return this.getLowestLevel(currentConstraintLevel, subProcessLevel);
        }
        return null;
    }

    private Level getSubProcessLevel() {
        XmlConclusion conclusion = this.ccResult.getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getErrors())) {
                return Level.FAIL;
            }
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getWarnings())) {
                return Level.WARN;
            }
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getInfos())) {
                return Level.INFORM;
            }
        }
        return null;
    }

    private Level getLowestLevel(Level currentLevel, Level subProcessLevel) {
        if (currentLevel == null) {
            return subProcessLevel;
        }
        if (subProcessLevel == null) {
            return currentLevel;
        }
        if (Level.INFORM == currentLevel || Level.INFORM == subProcessLevel) {
            return Level.INFORM;
        }
        if (Level.WARN == currentLevel || Level.WARN == subProcessLevel) {
            return Level.WARN;
        }
        if (Level.FAIL == currentLevel || Level.FAIL == subProcessLevel) {
            return Level.FAIL;
        }
        return currentLevel;
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.extractXmlMessage();
    }

    private XmlMessage extractXmlMessage() {
        XmlConclusion conclusion = this.ccResult.getConclusion();
        if (conclusion != null) {
            ArrayList messages = new ArrayList();
            switch (this.getLevel()) {
                case INFORM: {
                    messages.addAll(conclusion.getInfos());
                    messages.addAll(conclusion.getWarnings());
                    messages.addAll(conclusion.getErrors());
                    break;
                }
                case WARN: {
                    messages.addAll(conclusion.getWarnings());
                    messages.addAll(conclusion.getErrors());
                    break;
                }
                case FAIL: {
                    messages.addAll(conclusion.getErrors());
                    break;
                }
            }
            if (Utils.isCollectionNotEmpty(messages)) {
                return (XmlMessage)messages.iterator().next();
            }
        }
        return null;
    }
}

