/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestCryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DigestMatcherCryptographicCheckerResultCheck;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DigestMatcherListCryptographicChainBuilder<T extends XmlConstraintsConclusion> {
    private final I18nProvider i18nProvider;
    private final T result;
    private final List<XmlDigestMatcher> digestMatchers;
    private final Date validationTime;
    private final CryptographicConstraint constraint;
    private XmlCC concernedCC;
    private List<String> concernedMaterial;

    public DigestMatcherListCryptographicChainBuilder(I18nProvider i18nProvider, T result, List<XmlDigestMatcher> digestMatchers, Date validationTime, CryptographicConstraint constraint) {
        this.i18nProvider = i18nProvider;
        this.result = result;
        this.digestMatchers = digestMatchers;
        this.validationTime = validationTime;
        this.constraint = constraint;
    }

    public ChainItem<T> build(ChainItem<T> chainItem) {
        if (Utils.isCollectionEmpty(this.digestMatchers)) {
            return chainItem;
        }
        Set<DigestAlgorithm> usedDigestAlgorithms = this.getUsedDigestAlgorithms(this.digestMatchers);
        Set<MessageTag> usedPositions = this.getUsedPositions(this.digestMatchers);
        for (DigestAlgorithm digestAlgorithm : usedDigestAlgorithms) {
            for (MessageTag position : usedPositions) {
                List<XmlDigestMatcher> digestMatchersGroup = this.getDigestMatchersByAlgorithmAndPosition(this.digestMatchers, digestAlgorithm, position);
                if (!Utils.isCollectionNotEmpty(digestMatchersGroup)) continue;
                DigestCryptographicChecker dac = new DigestCryptographicChecker(this.i18nProvider, digestAlgorithm, this.validationTime, position, this.constraint);
                XmlCC dacResult = (XmlCC)dac.execute();
                chainItem = chainItem.setNextItem(this.digestAlgorithmCheckResult(digestMatchersGroup, dacResult, this.constraint));
                if (this.concernedCC != null && Indication.PASSED == dacResult.getConclusion().getIndication()) continue;
                this.concernedCC = dacResult;
                this.concernedMaterial = this.getReferenceNames(digestMatchersGroup);
            }
        }
        return chainItem;
    }

    public XmlCC getConcernedCC() {
        return this.concernedCC;
    }

    public List<String> getConcernedMaterial() {
        return this.concernedMaterial;
    }

    private Set<DigestAlgorithm> getUsedDigestAlgorithms(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().map(XmlDigestAlgoAndValue::getDigestMethod).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<MessageTag> getUsedPositions(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().map(ValidationProcessUtils::getDigestMatcherCryptoPosition).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<XmlDigestMatcher> getDigestMatchersByAlgorithmAndPosition(List<XmlDigestMatcher> digestMatchers, DigestAlgorithm digestAlgorithm, MessageTag position) {
        if (position == null) {
            return Collections.emptyList();
        }
        return digestMatchers.stream().filter(d -> digestAlgorithm == d.getDigestMethod() && position == ValidationProcessUtils.getDigestMatcherCryptoPosition(d) && DigestMatcherType.COUNTER_SIGNED_SIGNATURE_VALUE != d.getType()).collect(Collectors.toList());
    }

    private ChainItem<T> digestAlgorithmCheckResult(List<XmlDigestMatcher> digestMatchers, XmlCC ccResult, CryptographicConstraint constraint) {
        MessageTag position = ValidationProcessUtils.getDigestMatcherCryptoPosition(digestMatchers);
        return new DigestMatcherCryptographicCheckerResultCheck<T>(this.i18nProvider, this.result, this.validationTime, position, this.getReferenceNames(digestMatchers), ccResult, (LevelConstraint)constraint);
    }

    private List<String> getReferenceNames(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().map(d -> d.getId() != null ? d.getId() : (d.getUri() != null ? d.getUri() : d.getDocumentName())).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

