/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.identifier;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.MultipleDigestIdentifier;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.ParsingInfoRecord;
import eu.europa.esig.dss.model.tsl.PivotInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserFriendlyIdentifierProvider
implements TokenIdentifierProvider {
    private static final Logger LOG = LoggerFactory.getLogger(UserFriendlyIdentifierProvider.class);
    private static final String STRING_DELIMITER = "_";
    private static final String NAME_REPLACEMENT = "-";
    private static final String ISSUER = "ISSUER-";
    private static final String SERIAL = "SERIAL-";
    private static final String UNKNOWN_SIGNER = "UNKNOWN-SIGNER";
    private static final String UNNAMED_SIGNER = "UNNAMED-SIGNER";
    private final Map<String, String> uniqueTokenIdsMap = new HashMap<String, String>();
    private final Map<String, String> generatedTokenIdsMap = new HashMap<String, String>();
    private String signaturePrefix = "SIGNATURE";
    private String counterSignaturePrefix = "COUNTER-SIGNATURE";
    private String timestampPrefix = "TIMESTAMP";
    private String certificatePrefix = "CERTIFICATE";
    private String crlPrefix = "CRL";
    private String ocspPrefix = "OCSP";
    private String signedDataPrefix = "DOCUMENT";
    private String evidenceRecordPrefix = "EVIDENCE-RECORD";
    private String lotlPrefix = "LOTL";
    private String tlPrefix = "TL";
    private String pivotPrefix = "PIVOT";
    private String dateFormat = "yyyyMMdd-HHmm";

    public void setSignaturePrefix(String signaturePrefix) {
        this.assertNotBlank(signaturePrefix);
        this.signaturePrefix = signaturePrefix;
    }

    public void setCounterSignaturePrefix(String counterSignaturePrefix) {
        this.assertNotBlank(counterSignaturePrefix);
        this.counterSignaturePrefix = counterSignaturePrefix;
    }

    public void setTimestampPrefix(String timestampPrefix) {
        this.assertNotBlank(timestampPrefix);
        this.timestampPrefix = timestampPrefix;
    }

    public void setCertificatePrefix(String certificatePrefix) {
        this.assertNotBlank(certificatePrefix);
        this.certificatePrefix = certificatePrefix;
    }

    public void setCrlPrefix(String crlPrefix) {
        this.assertNotBlank(crlPrefix);
        this.crlPrefix = crlPrefix;
    }

    public void setOcspPrefix(String ocspPrefix) {
        this.assertNotBlank(ocspPrefix);
        this.ocspPrefix = ocspPrefix;
    }

    public void setSignedDataPrefix(String signedDataPrefix) {
        this.assertNotBlank(signedDataPrefix);
        this.signedDataPrefix = signedDataPrefix;
    }

    public void setEvidenceRecordPrefix(String evidenceRecordPrefix) {
        this.evidenceRecordPrefix = evidenceRecordPrefix;
    }

    public void setLOTLPrefix(String lotlPrefix) {
        this.lotlPrefix = lotlPrefix;
    }

    public void setTLPrefix(String tlPrefix) {
        this.tlPrefix = tlPrefix;
    }

    public void setPivotPrefix(String pivotPrefix) {
        this.pivotPrefix = pivotPrefix;
    }

    public void setDateFormat(String dateFormat) {
        Objects.requireNonNull(dateFormat, "The dataFormat cannot be null!");
        this.dateFormat = dateFormat;
    }

    public String getIdAsString(IdentifierBasedObject object) {
        Objects.requireNonNull(object, "The object cannot be null!");
        String cachedIdentifier = this.getCachedIdentifier(object);
        if (Utils.isStringNotEmpty((String)cachedIdentifier)) {
            return cachedIdentifier;
        }
        if (object instanceof AdvancedSignature) {
            return this.getIdAsStringForSignature((AdvancedSignature)object);
        }
        if (object instanceof Token) {
            return this.getIdAsStringForToken((Token)object);
        }
        if (object instanceof SignatureScope) {
            return this.getIdAsStringForSignatureScope((SignatureScope)object);
        }
        if (object instanceof TLInfo) {
            return this.getIdAsStringForTL((TLInfo)object);
        }
        if (object instanceof CertificateRef) {
            return this.getIdAsStringForCertRef((CertificateRef)object);
        }
        if (object instanceof RevocationRef) {
            return this.getIdAsStringForRevRef((RevocationRef)object);
        }
        if (object instanceof EncapsulatedRevocationTokenIdentifier) {
            return this.getIdAsStringForRevTokenIdentifier((EncapsulatedRevocationTokenIdentifier)object);
        }
        if (object instanceof EvidenceRecord) {
            return this.getIdAsStringForEvidenceRecordIdentifier((EvidenceRecord)object);
        }
        LOG.warn("The class '{}' is not supported! Return the original identifier for the object.", (Object)object.getClass());
        return object.getDSSId().asXmlId();
    }

    private String getCachedIdentifier(IdentifierBasedObject object) {
        Identifier identifier = object.getDSSId();
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("The returned Identifier cannot be null for the object of class '%s'!", object.getClass()));
        }
        String originalIdentifier = identifier.asXmlId();
        String value = this.uniqueTokenIdsMap.get(originalIdentifier);
        if (value != null) {
            LOG.trace("The identifier for the token with Id '{}' has been found in the map. Returning the value...", (Object)originalIdentifier);
            return value;
        }
        LOG.trace("Computing the user-friendly identifier for the token with Id '{}'...", (Object)originalIdentifier);
        return null;
    }

    protected String getIdAsStringForSignature(AdvancedSignature signature) {
        X500PrincipalHelper subject = signature.getSigningCertificateToken() != null ? signature.getSigningCertificateToken().getSubject() : null;
        String prefix = signature.isCounterSignature() ? this.counterSignaturePrefix : this.signaturePrefix;
        return this.createIdString(prefix, subject, signature.getSigningTime(), signature.getId());
    }

    protected String getIdAsStringForToken(Token token) {
        return this.createIdString(this.getTokenPrefix(token), this.getTokenSubject(token), token.getCreationDate(), token.getDSSIdAsString());
    }

    protected String getIdAsStringForSignatureScope(SignatureScope signatureScope) {
        StringBuilder stringBuilder = new StringBuilder(this.signedDataPrefix);
        stringBuilder.append(STRING_DELIMITER);
        String documentName = signatureScope.getName((TokenIdentifierProvider)this);
        if (Utils.isStringNotBlank((String)documentName)) {
            stringBuilder.append(this.getUserFriendlyString(documentName));
        } else {
            stringBuilder.append(signatureScope.getType().toString());
        }
        return this.generateId(stringBuilder, signatureScope.getDSSIdAsString());
    }

    protected String getIdAsStringForTL(TLInfo tlInfo) {
        StringBuilder stringBuilder = new StringBuilder(this.getTlPrefix(tlInfo));
        ParsingInfoRecord parsingCacheInfo = tlInfo.getParsingCacheInfo();
        if (parsingCacheInfo != null) {
            if (Utils.isStringNotBlank((String)parsingCacheInfo.getTerritory())) {
                stringBuilder.append(STRING_DELIMITER);
                stringBuilder.append(this.getUserFriendlyString(parsingCacheInfo.getTerritory()));
            }
            if (parsingCacheInfo.getIssueDate() != null) {
                stringBuilder.append(STRING_DELIMITER);
                stringBuilder.append(DSSUtils.formatDateWithCustomFormat((Date)parsingCacheInfo.getIssueDate(), (String)this.dateFormat));
            }
        }
        return this.generateId(stringBuilder, tlInfo.getDSSIdAsString());
    }

    protected String getIdAsStringForCertRef(CertificateRef certificateRef) {
        StringBuilder stringBuilder = new StringBuilder(this.certificatePrefix);
        if (certificateRef.getResponderId() != null && certificateRef.getResponderId().getX500Principal() != null) {
            stringBuilder.append(STRING_DELIMITER);
            X500PrincipalHelper x500PrincipalHelper = new X500PrincipalHelper(certificateRef.getResponderId().getX500Principal());
            stringBuilder.append(this.getHumanReadableName(x500PrincipalHelper));
        } else if (certificateRef.getCertificateIdentifier() != null) {
            if (certificateRef.getCertificateIdentifier().getIssuerName() != null) {
                stringBuilder.append(STRING_DELIMITER);
                stringBuilder.append(ISSUER);
                X500PrincipalHelper x500PrincipalHelper = new X500PrincipalHelper(certificateRef.getCertificateIdentifier().getIssuerName());
                stringBuilder.append(this.getHumanReadableName(x500PrincipalHelper));
            }
            if (certificateRef.getCertificateIdentifier().getSerialNumber() != null) {
                stringBuilder.append(STRING_DELIMITER);
                stringBuilder.append(SERIAL);
                stringBuilder.append(certificateRef.getCertificateIdentifier().getSerialNumber());
            }
        } else if (certificateRef.getCertDigest() != null) {
            stringBuilder.append(STRING_DELIMITER);
            stringBuilder.append(certificateRef.getCertDigest().getHexValue());
        }
        return this.generateId(stringBuilder, certificateRef.getDSSIdAsString());
    }

    protected String getIdAsStringForRevRef(RevocationRef<?> revocationRef) {
        StringBuilder stringBuilder = new StringBuilder(this.getRevocationRefPrefix(revocationRef));
        stringBuilder.append(STRING_DELIMITER);
        stringBuilder.append(revocationRef.getDigest().getHexValue());
        return this.generateId(stringBuilder, revocationRef.getDSSIdAsString());
    }

    protected String getIdAsStringForRevTokenIdentifier(EncapsulatedRevocationTokenIdentifier<?> revocationIdentifier) {
        StringBuilder stringBuilder = new StringBuilder(this.getRevocationIdentifierPrefix(revocationIdentifier));
        stringBuilder.append(STRING_DELIMITER);
        stringBuilder.append(Utils.toHex((byte[])revocationIdentifier.getDigestValue(DigestAlgorithm.SHA256)));
        return this.generateId(stringBuilder, revocationIdentifier.asXmlId());
    }

    protected String getIdAsStringForEvidenceRecordIdentifier(EvidenceRecord evidenceRecord) {
        StringBuilder stringBuilder = new StringBuilder(this.evidenceRecordPrefix);
        stringBuilder.append(STRING_DELIMITER);
        List timestamps = evidenceRecord.getTimestamps();
        if (Utils.isCollectionNotEmpty((Collection)timestamps)) {
            stringBuilder.append(this.getDeterministicIdPart((Token)timestamps.get(0)));
        } else {
            stringBuilder.append(Utils.toHex((byte[])((MultipleDigestIdentifier)evidenceRecord.getDSSId()).getDigestValue(DigestAlgorithm.SHA256)));
        }
        return this.generateId(stringBuilder, evidenceRecord.getId());
    }

    private String createIdString(String prefix, X500PrincipalHelper subject, Date creationDate, String dssId) {
        StringBuilder stringBuilder = new StringBuilder(prefix);
        stringBuilder.append(STRING_DELIMITER);
        stringBuilder.append(this.getDeterministicIdPart(subject, creationDate));
        return this.generateId(stringBuilder, dssId);
    }

    private String getDeterministicIdPart(Token token) {
        return this.getDeterministicIdPart(this.getTokenSubject(token), token.getCreationDate());
    }

    private String getDeterministicIdPart(X500PrincipalHelper subject, Date creationDate) {
        StringBuilder stringBuilder = new StringBuilder();
        if (subject != null) {
            stringBuilder.append(this.getHumanReadableName(subject));
        } else {
            stringBuilder.append(UNKNOWN_SIGNER);
        }
        if (creationDate != null) {
            stringBuilder.append(STRING_DELIMITER);
            stringBuilder.append(DSSUtils.formatDateWithCustomFormat((Date)creationDate, (String)this.dateFormat));
        }
        return stringBuilder.toString();
    }

    private String getHumanReadableName(X500PrincipalHelper subject) {
        String name = DSSASN1Utils.getHumanReadableName((X500PrincipalHelper)subject);
        if (Utils.isStringNotEmpty((String)name)) {
            return this.getUserFriendlyString(name);
        }
        return UNNAMED_SIGNER;
    }

    private String generateId(StringBuilder stringBuilder, String dssId) {
        String generatedId = stringBuilder.toString();
        Long duplicatesNumber = this.getDuplicatesNumber(generatedId, dssId);
        if (duplicatesNumber != 0L) {
            stringBuilder.append(STRING_DELIMITER);
            duplicatesNumber = duplicatesNumber + 1L;
            stringBuilder.append(duplicatesNumber);
        }
        this.generatedTokenIdsMap.put(dssId, generatedId);
        String uniqueId = stringBuilder.toString();
        this.uniqueTokenIdsMap.put(dssId, uniqueId);
        return uniqueId;
    }

    private Long getDuplicatesNumber(String builtId, String dssId) {
        return this.generatedTokenIdsMap.entrySet().stream().filter(e -> !dssId.equals(e.getKey()) && builtId.equals(e.getValue())).count();
    }

    private String getTokenPrefix(Token token) {
        if (token instanceof CertificateToken) {
            return this.certificatePrefix;
        }
        if (token instanceof CRLToken) {
            return this.crlPrefix;
        }
        if (token instanceof OCSPToken) {
            return this.ocspPrefix;
        }
        if (token instanceof TimestampToken) {
            return this.timestampPrefix;
        }
        throw new IllegalArgumentException(String.format("Unsupported token of class '%s' has been reached!", token.getClass()));
    }

    private X500PrincipalHelper getTokenSubject(Token token) {
        X500PrincipalHelper subject = null;
        if (token instanceof CertificateToken) {
            CertificateToken certificateToken = (CertificateToken)token;
            subject = certificateToken.getSubject();
        } else {
            X500Principal issuerX500Principal = token.getIssuerX500Principal();
            if (issuerX500Principal != null) {
                subject = new X500PrincipalHelper(issuerX500Principal);
            }
        }
        return subject;
    }

    private String getTlPrefix(TLInfo tlInfo) {
        if (tlInfo instanceof PivotInfo) {
            return this.pivotPrefix;
        }
        if (tlInfo instanceof LOTLInfo) {
            return this.lotlPrefix;
        }
        return this.tlPrefix;
    }

    private String getRevocationRefPrefix(RevocationRef<?> revocationRef) {
        if (revocationRef instanceof CRLRef) {
            return this.crlPrefix;
        }
        if (revocationRef instanceof OCSPRef) {
            return this.ocspPrefix;
        }
        throw new IllegalArgumentException(String.format("Unsupported RevocationRef of class '%s' has been reached!", revocationRef.getClass()));
    }

    private String getRevocationIdentifierPrefix(EncapsulatedRevocationTokenIdentifier<?> revocationIdentifier) {
        if (revocationIdentifier instanceof CRLBinary) {
            return this.crlPrefix;
        }
        if (revocationIdentifier instanceof OCSPResponseBinary) {
            return this.ocspPrefix;
        }
        throw new IllegalArgumentException(String.format("Unsupported RevocationTokenIdentifier of class '%s' has been reached!", revocationIdentifier.getClass()));
    }

    private String getUserFriendlyString(String str) {
        str = DSSUtils.removeControlCharacters((String)str);
        str = DSSUtils.replaceAllNonAlphanumericCharacters((String)str, (String)NAME_REPLACEMENT);
        return this.trim(str, NAME_REPLACEMENT);
    }

    private String trim(String str, String trimmedStr) {
        while (str.length() > trimmedStr.length() && str.startsWith(trimmedStr)) {
            str = Utils.substringAfter((String)str, (String)trimmedStr);
        }
        while (str.length() > trimmedStr.length() && str.endsWith(trimmedStr)) {
            str = str.substring(0, str.length() - trimmedStr.length());
        }
        return str;
    }

    private void assertNotBlank(String str) {
        if (Utils.isStringBlank((String)str)) {
            throw new IllegalArgumentException("The prefix cannot be null or blank!");
        }
    }
}

