/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.OriginalIdentifierProvider;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.CertificateVerifierBuilder;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.executor.DefaultValidationContextExecutor;
import eu.europa.esig.dss.spi.validation.executor.ValidationContextExecutor;
import eu.europa.esig.dss.validation.executor.ProcessExecutorProvider;
import eu.europa.esig.dss.validation.executor.certificate.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.DefaultCertificateProcessExecutor;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import eu.europa.esig.dss.validation.reports.diagnostic.CertificateDiagnosticDataBuilder;
import eu.europa.esig.dss.validation.reports.diagnostic.DiagnosticDataBuilder;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValidator
implements ProcessExecutorProvider<CertificateProcessExecutor> {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateValidator.class);
    private final CertificateToken token;
    private Date validationTime;
    private CertificateVerifier certificateVerifier;
    private TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    private TokenIdentifierProvider identifierProvider = new OriginalIdentifierProvider();
    private ValidationContextExecutor validationContextExecutor = DefaultValidationContextExecutor.INSTANCE;
    private Locale locale = Locale.getDefault();
    private CertificateProcessExecutor processExecutor;

    private CertificateValidator(CertificateToken token) {
        Objects.requireNonNull(token, "The certificate is missing");
        this.token = token;
    }

    public static CertificateValidator fromCertificate(CertificateToken token) {
        return new CertificateValidator(token);
    }

    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        Objects.requireNonNull(tokenExtractionStrategy);
        this.tokenExtractionStrategy = tokenExtractionStrategy;
    }

    public void setTokenIdentifierProvider(TokenIdentifierProvider identifierProvider) {
        Objects.requireNonNull(identifierProvider);
        this.identifierProvider = identifierProvider;
    }

    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private Date getValidationTime() {
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        return this.validationTime;
    }

    public void setValidationContextExecutor(ValidationContextExecutor validationContextExecutor) {
        Objects.requireNonNull(validationContextExecutor);
        this.validationContextExecutor = validationContextExecutor;
    }

    public CertificateReports validate() {
        ValidationPolicy defaultPolicy;
        try {
            defaultPolicy = ValidationPolicyFacade.newFacade().getCertificateValidationPolicy();
        }
        catch (Exception e) {
            throw new DSSException("Unable to load the default policy", (Throwable)e);
        }
        return this.validate(defaultPolicy);
    }

    public CertificateReports validate(InputStream policyDataStream) {
        try {
            if (policyDataStream == null) {
                LOG.debug("No provided validation policy : use the default policy");
                return this.validate();
            }
            ValidationPolicy validationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(policyDataStream);
            return this.validate(validationPolicy);
        }
        catch (Exception e) {
            throw new IllegalInputException("Unable to load the policy", (Throwable)e);
        }
    }

    public CertificateReports validate(ValidationPolicy validationPolicy) {
        this.assertConfigurationValid();
        XmlDiagnosticData diagnosticData = this.getDiagnosticData();
        CertificateProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setDiagnosticData(diagnosticData);
        executor.setCertificateId(this.identifierProvider.getIdAsString((IdentifierBasedObject)this.token));
        executor.setLocale(this.locale);
        executor.setCurrentTime(this.getValidationTime());
        return (CertificateReports)executor.execute();
    }

    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.token, "Certificate token is not provided to the validator");
    }

    public final XmlDiagnosticData getDiagnosticData() {
        return this.prepareDiagnosticDataBuilder().build();
    }

    protected ValidationContext prepareValidationContext(CertificateVerifier certificateVerifier) {
        ValidationContext svc = this.createValidationContext();
        svc.initialize(certificateVerifier);
        svc.addCertificateTokenForVerification(this.token);
        return svc;
    }

    protected ValidationContext createValidationContext() {
        return new SignatureValidationContext(this.getValidationTime());
    }

    protected DiagnosticDataBuilder prepareDiagnosticDataBuilder() {
        CertificateVerifier certificateVerifierForValidation = new CertificateVerifierBuilder(this.certificateVerifier).buildCompleteCopyForValidation();
        ValidationContext validationContext = this.prepareValidationContext(certificateVerifierForValidation);
        this.validateContext(validationContext);
        return this.createDiagnosticDataBuilder(validationContext);
    }

    protected void validateContext(ValidationContext validationContext) {
        this.validationContextExecutor.validate(validationContext);
    }

    protected DiagnosticDataBuilder createDiagnosticDataBuilder(ValidationContext validationContext) {
        return ((CertificateDiagnosticDataBuilder)((CertificateDiagnosticDataBuilder)new CertificateDiagnosticDataBuilder().usedCertificates(validationContext.getProcessedCertificates())).usedRevocations(validationContext.getProcessedRevocations())).allCertificateSources(validationContext.getAllCertificateSources()).defaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm()).tokenExtractionStrategy(this.tokenExtractionStrategy).tokenIdentifierProvider(this.identifierProvider).validationDate(this.getValidationTime());
    }

    @Override
    public void setProcessExecutor(CertificateProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public CertificateProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public CertificateProcessExecutor getDefaultProcessExecutor() {
        return new DefaultCertificateProcessExecutor();
    }
}

