/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.MRA;
import eu.europa.esig.dss.spi.tsl.OtherTSLPointer;
import eu.europa.esig.dss.tsl.function.converter.DigitalIdentityListTypeConverter;
import eu.europa.esig.dss.tsl.function.converter.InternationalNamesTypeConverter;
import eu.europa.esig.dss.tsl.function.converter.MRAConverter;
import eu.europa.esig.dss.tsl.function.converter.NonEmptyMultiLangURIListTypeConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.mra.MutualRecognitionAgreementInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.AdditionalInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.AnyType;
import eu.europa.esig.trustedlist.jaxb.tsl.DigitalIdentityListType;
import eu.europa.esig.trustedlist.jaxb.tsl.InternationalNamesType;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIListType;
import eu.europa.esig.trustedlist.jaxb.tsl.OtherTSLPointerType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceDigitalIdentityListType;
import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class OtherTSLPointerConverter
implements Function<OtherTSLPointerType, OtherTSLPointer> {
    private static final String SCHEME_TERRITORY = "SchemeTerritory";
    private static final String TSL_TYPE = "TSLType";
    private static final String MIME_TYPE = "MimeType";
    private static final String SCHEME_OPERATOR_NAME = "SchemeOperatorName";
    private static final String SCHEME_TYPE_COMMUNITY_RULES = "SchemeTypeCommunityRules";
    private static final String MRA = "MutualRecognitionAgreementInformation";
    private boolean mraSupport;

    public OtherTSLPointerConverter() {
    }

    public OtherTSLPointerConverter(boolean mraSupport) {
        this.mraSupport = mraSupport;
    }

    @Override
    public OtherTSLPointer apply(OtherTSLPointerType original) {
        return new OtherTSLPointer.OtherTSLPointerBuilder().setSdiCertificates(this.getCertificates(original.getServiceDigitalIdentities())).setTslLocation(original.getTSLLocation()).setSchemeTerritory(this.getSchemeTerritory(original.getAdditionalInformation())).setTslType(this.getTSLType(original.getAdditionalInformation())).setMimeType(this.getMimeType(original.getAdditionalInformation())).setSchemeOperatorNames(this.getSchemeOperatorNames(original.getAdditionalInformation())).setSchemeTypeCommunityRules(this.getSchemeTypeCommunityRules(original.getAdditionalInformation())).setMra(this.getMRA(original.getAdditionalInformation())).build();
    }

    private List<CertificateToken> getCertificates(ServiceDigitalIdentityListType serviceDigitalIdentities) {
        ArrayList<CertificateToken> certificates = new ArrayList<CertificateToken>();
        if (serviceDigitalIdentities != null && Utils.isCollectionNotEmpty((Collection)serviceDigitalIdentities.getServiceDigitalIdentity())) {
            DigitalIdentityListTypeConverter converter = new DigitalIdentityListTypeConverter();
            for (DigitalIdentityListType digitalIdentityList : serviceDigitalIdentities.getServiceDigitalIdentity()) {
                certificates.addAll(converter.apply(digitalIdentityList));
            }
        }
        return certificates;
    }

    private String getSchemeTerritory(AdditionalInformationType additionalInformation) {
        return this.getOtherInformationValue(additionalInformation, String.class, SCHEME_TERRITORY);
    }

    private String getTSLType(AdditionalInformationType additionalInformation) {
        return this.getOtherInformationValue(additionalInformation, String.class, TSL_TYPE);
    }

    private String getMimeType(AdditionalInformationType additionalInformation) {
        return this.getOtherInformationValue(additionalInformation, String.class, MIME_TYPE);
    }

    private Map<String, List<String>> getSchemeOperatorNames(AdditionalInformationType additionalInformation) {
        InternationalNamesType schemeOperatorNames = this.getOtherInformationValue(additionalInformation, InternationalNamesType.class, SCHEME_OPERATOR_NAME);
        if (schemeOperatorNames != null) {
            return new InternationalNamesTypeConverter().apply(schemeOperatorNames);
        }
        return null;
    }

    private Map<String, List<String>> getSchemeTypeCommunityRules(AdditionalInformationType additionalInformation) {
        NonEmptyMultiLangURIListType schemeTypeCommunityRules = this.getOtherInformationValue(additionalInformation, NonEmptyMultiLangURIListType.class, SCHEME_TYPE_COMMUNITY_RULES);
        if (schemeTypeCommunityRules != null) {
            return new NonEmptyMultiLangURIListTypeConverter().apply(schemeTypeCommunityRules);
        }
        return null;
    }

    private MRA getMRA(AdditionalInformationType additionalInformation) {
        MutualRecognitionAgreementInformationType jaxbMRA;
        if (this.mraSupport && (jaxbMRA = this.getOtherInformationValue(additionalInformation, MutualRecognitionAgreementInformationType.class, MRA)) != null) {
            MRAConverter converter = new MRAConverter();
            return converter.apply(jaxbMRA);
        }
        return null;
    }

    private <T extends Serializable> T getOtherInformationValue(AdditionalInformationType additionalInformation, Class<T> targetClass, String elementName) {
        if (additionalInformation != null && Utils.isCollectionNotEmpty((Collection)additionalInformation.getTextualInformationOrOtherInformation())) {
            for (Serializable serializableObj : additionalInformation.getTextualInformationOrOtherInformation()) {
                if (!(serializableObj instanceof AnyType)) continue;
                AnyType anytype = (AnyType)serializableObj;
                List content = anytype.getContent();
                for (Object objectValue : content) {
                    if (!(objectValue instanceof JAXBElement)) continue;
                    JAXBElement jaxbElement = (JAXBElement)objectValue;
                    Object value = jaxbElement.getValue();
                    if (!jaxbElement.getName().getLocalPart().equals(elementName) || !targetClass.isInstance(value)) continue;
                    return (T)((Serializable)value);
                }
            }
        }
        return null;
    }
}

