/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRefIdentifier;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class OCSPRefIdentifier
extends RevocationRefIdentifier {
    private static final long serialVersionUID = 3113937346660525679L;

    protected OCSPRefIdentifier(OCSPRef ocspRef) {
        super(OCSPRefIdentifier.getDigest(ocspRef));
    }

    private static Digest getDigest(OCSPRef ocspRef) {
        byte[] bytes;
        if (ocspRef.getDigest() != null) {
            return ocspRef.getDigest();
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(baos);){
            ResponderId responderId;
            if (ocspRef.getProducedAt() != null) {
                dos.writeLong(ocspRef.getProducedAt().getTime());
            }
            if ((responderId = ocspRef.getResponderId()) != null) {
                if (responderId.getSki() != null) {
                    dos.write(responderId.getSki());
                }
                if (responderId.getX500Principal() != null) {
                    dos.writeChars(responderId.getX500Principal().toString());
                }
            }
            dos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new DSSException("Cannot build DSS ID for the OCSP Ref.", (Throwable)e);
        }
        return new Digest(DIGEST_ALGO, DSSUtils.digest(DIGEST_ALGO, bytes));
    }
}

