/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import java.io.InputStream;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class ExternalResourcesOCSPSource
extends OfflineOCSPSource {
    private static final long serialVersionUID = -332201368387706970L;

    public ExternalResourcesOCSPSource(String ... paths) {
        for (String pathItem : paths) {
            this.load(this.getClass().getResourceAsStream(pathItem));
        }
    }

    public ExternalResourcesOCSPSource(InputStream ... inputStreams) {
        for (InputStream inputStream : inputStreams) {
            this.load(inputStream);
        }
    }

    public ExternalResourcesOCSPSource(DSSDocument ... dssDocuments) {
        for (DSSDocument document : dssDocuments) {
            this.load(document.openStream());
        }
    }

    private void load(InputStream inputStream) {
        try (InputStream is = inputStream;){
            OCSPResp ocspResp = new OCSPResp(is);
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
            this.addBinary(OCSPResponseBinary.build(basicOCSPResp), RevocationOrigin.EXTERNAL);
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to load OCSP token : %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public List<RevocationToken<OCSP>> getRevocationTokens(CertificateToken certificate, CertificateToken issuer) {
        List<RevocationToken<OCSP>> revocationTokens = super.getRevocationTokens(certificate, issuer);
        for (RevocationToken<OCSP> revocationToken : revocationTokens) {
            revocationToken.setExternalOrigin(RevocationOrigin.EXTERNAL);
        }
        return revocationTokens;
    }
}

