/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class CMSSignedDataBuilder {
    private CertificateToken signingCertificate;
    private Collection<CertificateToken> certificateChain;
    private boolean generateWithoutCertificates = false;
    private CertificateSource trustedCertificateSource;
    private boolean trustAnchorBPPolicy = true;
    private CMSSignedData originalCMSSignedData;
    private boolean encapsulate = true;

    public CMSSignedDataBuilder setSigningCertificate(CertificateToken signingCertificate) {
        this.signingCertificate = signingCertificate;
        return this;
    }

    public CMSSignedDataBuilder setCertificateChain(Collection<CertificateToken> certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public CMSSignedDataBuilder setGenerateWithoutCertificates(boolean generateWithoutCertificates) {
        this.generateWithoutCertificates = generateWithoutCertificates;
        return this;
    }

    public CMSSignedDataBuilder setTrustedCertificateSource(CertificateSource trustedCertificateSource) {
        this.trustedCertificateSource = trustedCertificateSource;
        return this;
    }

    public CMSSignedDataBuilder setTrustAnchorBPPolicy(boolean trustAnchorBPPolicy) {
        this.trustAnchorBPPolicy = trustAnchorBPPolicy;
        return this;
    }

    public CMSSignedDataBuilder setOriginalCMSSignedData(CMSSignedData originalCMSSignedData) {
        this.originalCMSSignedData = originalCMSSignedData;
        return this;
    }

    public CMSSignedDataBuilder setEncapsulate(boolean encapsulate) {
        this.encapsulate = encapsulate;
        return this;
    }

    public CMSSignedData createCMSSignedData(SignerInfoGenerator signerInfoGenerator, DSSDocument toSignDocument) {
        CMSSignedDataGenerator cmsSignedDataGenerator = this.createCMSSignedDataGenerator(signerInfoGenerator);
        CMSTypedData contentToBeSigned = this.getContentToBeSigned(toSignDocument);
        return this.generateCMSSignedData(cmsSignedDataGenerator, contentToBeSigned);
    }

    public CMSSignedDataGenerator createCMSSignedDataGenerator(SignerInfoGenerator signerInfoGenerator) {
        try {
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            generator.addSignerInfoGenerator(signerInfoGenerator);
            LinkedList<CertificateToken> certificates = new LinkedList<CertificateToken>();
            if (this.originalCMSSignedData != null) {
                generator.addSigners(this.originalCMSSignedData.getSignerInfos());
                generator.addAttributeCertificates(this.originalCMSSignedData.getAttributeCertificates());
                generator.addCRLs(this.originalCMSSignedData.getCRLs());
                generator.addOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic, this.originalCMSSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic));
                generator.addOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response, this.originalCMSSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response));
                Store certificateStore = this.originalCMSSignedData.getCertificates();
                Collection certificatesMatches = certificateStore.getMatches(null);
                for (X509CertificateHolder certificatesMatch : certificatesMatches) {
                    CertificateToken token = DSSASN1Utils.getCertificate(certificatesMatch);
                    if (certificates.contains(token)) continue;
                    certificates.add(token);
                }
            }
            JcaCertStore jcaCertStore = this.getJcaCertStore(certificates);
            generator.addCertificates((Store)jcaCertStore);
            return generator;
        }
        catch (CMSException e) {
            throw new DSSException(String.format("Unable to create a CMSSignedDataGenerator. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    protected CMSTypedData getContentToBeSigned(DSSDocument toSignData) {
        CMSAbsentContent content;
        Objects.requireNonNull(toSignData, "Document to be signed is missing");
        if (toSignData instanceof DigestDocument) {
            content = new CMSAbsentContent();
        } else if (toSignData instanceof FileDocument) {
            FileDocument fileDocument = (FileDocument)toSignData;
            content = new CMSProcessableFile(fileDocument.getFile());
        } else {
            content = new CMSProcessableByteArray(DSSUtils.toByteArray(toSignData));
        }
        return content;
    }

    private CMSSignedData generateCMSSignedData(CMSSignedDataGenerator generator, CMSTypedData content) {
        try {
            CMSSignedData cmsSignedData = generator.generate(content, this.encapsulate);
            return this.populateDigestAlgorithmSet(cmsSignedData);
        }
        catch (CMSException e) {
            throw new DSSException("Unable to generate the CMSSignedData", (Throwable)e);
        }
    }

    private JcaCertStore getJcaCertStore(Collection<CertificateToken> certificates) {
        List<Object> certificatesToAdd = this.signingCertificate == null && this.generateWithoutCertificates ? new ArrayList() : new BaselineBCertificateSelector(this.signingCertificate, this.certificateChain).setTrustedCertificateSource(this.trustedCertificateSource).setTrustAnchorBPPolicy(this.trustAnchorBPPolicy).getCertificates();
        for (CertificateToken certificateToken : certificatesToAdd) {
            if (certificates.contains(certificateToken)) continue;
            certificates.add(certificateToken);
        }
        try {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            for (CertificateToken certificateToken : certificates) {
                certs.add(certificateToken.getCertificate());
            }
            return new JcaCertStore(certs);
        }
        catch (CertificateEncodingException e) {
            throw new DSSException(String.format("Unable to get JcaCertStore. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    public CMSSignedData extendCMSSignedData(Collection<CertificateToken> certificateTokens, Collection<CRLToken> crlTokens, Collection<OCSPToken> ocspTokens) {
        if (this.originalCMSSignedData == null) {
            throw new NullPointerException("Original CMSSignedData shall be provided! Use #setOriginalCMSSignedData(CMSSignedData) method.");
        }
        Store certificatesStore = this.originalCMSSignedData.getCertificates();
        HashSet<X509CertificateHolder> newCertificateStore = new HashSet<X509CertificateHolder>(certificatesStore.getMatches(null));
        for (CertificateToken certificateToken : certificateTokens) {
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(certificateToken);
            if (newCertificateStore.contains(x509CertificateHolder)) continue;
            newCertificateStore.add(x509CertificateHolder);
        }
        certificatesStore = new CollectionStore(newCertificateStore);
        Store attributeCertificatesStore = this.originalCMSSignedData.getAttributeCertificates();
        Store crlsStore = this.originalCMSSignedData.getCRLs();
        HashSet<Object> newCrlsStore = new HashSet<Object>(crlsStore.getMatches(null));
        for (CRLToken crlToken : crlTokens) {
            X509CRLHolder x509CRLHolder = this.getX509CrlHolder(crlToken);
            if (newCrlsStore.contains(x509CRLHolder)) continue;
            newCrlsStore.add(x509CRLHolder);
        }
        Store otherRevocationInfoFormatStoreOcsp = this.originalCMSSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        HashSet newOtherRevocationInfoFormatStore = new HashSet(otherRevocationInfoFormatStoreOcsp.getMatches(null));
        for (OCSPToken ocspToken : ocspTokens) {
            Object ocspResponseASN1Primitive = DSSASN1Utils.toASN1Primitive(ocspToken.getEncoded());
            if (newOtherRevocationInfoFormatStore.contains(ocspResponseASN1Primitive)) continue;
            newOtherRevocationInfoFormatStore.add(ocspResponseASN1Primitive);
        }
        otherRevocationInfoFormatStoreOcsp = new CollectionStore(newOtherRevocationInfoFormatStore);
        for (Object ocsp : otherRevocationInfoFormatStoreOcsp.getMatches(null)) {
            newCrlsStore.add(new OtherRevocationInfoFormat(CMSObjectIdentifiers.id_ri_ocsp_response, (ASN1Encodable)ocsp));
        }
        Store otherRevocationInfoFormatStoreBasic = this.originalCMSSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        for (Object ocsp : otherRevocationInfoFormatStoreBasic.getMatches(null)) {
            newCrlsStore.add(new OtherRevocationInfoFormat(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1Encodable)ocsp));
        }
        crlsStore = new CollectionStore(newCrlsStore);
        try {
            return CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.originalCMSSignedData, (Store)certificatesStore, (Store)attributeCertificatesStore, (Store)crlsStore);
        }
        catch (CMSException e) {
            throw new DSSException(String.format("Unable to re-create a CMS signature. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private X509CRLHolder getX509CrlHolder(CRLToken crlToken) {
        X509CRLHolder x509CRLHolder;
        block8: {
            InputStream is = crlToken.getCRLStream();
            try {
                x509CRLHolder = new X509CRLHolder(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException("Unable to convert X509CRL to X509CRLHolder", (Throwable)e);
                }
            }
            is.close();
        }
        return x509CRLHolder;
    }

    protected CMSSignedData populateDigestAlgorithmSet(CMSSignedData newCmsSignedData) {
        if (this.originalCMSSignedData != null) {
            for (AlgorithmIdentifier algorithmIdentifier : this.originalCMSSignedData.getDigestAlgorithmIDs()) {
                newCmsSignedData = this.addDigestAlgorithm(newCmsSignedData, algorithmIdentifier);
            }
        }
        return newCmsSignedData;
    }

    protected CMSSignedData addDigestAlgorithm(CMSSignedData cmsSignedData, AlgorithmIdentifier algorithmIdentifier) {
        return CMSSignedData.addDigestAlgorithm((CMSSignedData)cmsSignedData, (AlgorithmIdentifier)algorithmIdentifier);
    }
}

