/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.spi.tsl.TrustProperties;
import eu.europa.esig.dss.spi.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedListsCertificateSource
extends CommonTrustedCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedListsCertificateSource.class);
    private TLValidationJobSummary summary;
    private Map<EntityIdentifier, List<TrustProperties>> trustPropertiesByEntity = new HashMap<EntityIdentifier, List<TrustProperties>>();

    public TLValidationJobSummary getSummary() {
        return this.summary;
    }

    public void setSummary(TLValidationJobSummary summary) {
        this.summary = summary;
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.TRUSTED_LIST;
    }

    @Override
    public CertificateToken addCertificate(CertificateToken certificate) {
        throw new UnsupportedOperationException("Cannot directly add certificate to a TrustedListsCertificateSource");
    }

    public synchronized void setTrustPropertiesByCertificates(Map<CertificateToken, List<TrustProperties>> trustPropertiesByCerts) {
        this.trustPropertiesByEntity = new HashMap<EntityIdentifier, List<TrustProperties>>();
        super.reset();
        trustPropertiesByCerts.forEach(this::addCertificate);
    }

    private void addCertificate(CertificateToken certificateToken, List<TrustProperties> trustPropertiesList) {
        super.addCertificate(certificateToken);
        EntityIdentifier entityKey = certificateToken.getEntityKey();
        List list = this.trustPropertiesByEntity.computeIfAbsent(entityKey, k -> new ArrayList());
        for (TrustProperties trustProperties : trustPropertiesList) {
            if (list.contains(trustProperties)) continue;
            list.add(trustProperties);
        }
    }

    @Override
    public synchronized List<TrustProperties> getTrustServices(CertificateToken token) {
        List<TrustProperties> currentTrustProperties = this.trustPropertiesByEntity.get(token.getEntityKey());
        if (currentTrustProperties != null) {
            return currentTrustProperties;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAlternativeOCSPUrls(CertificateToken trustAnchor) {
        return this.getServiceSupplyPoints(trustAnchor, "ocsp");
    }

    @Override
    public List<String> getAlternativeCRLUrls(CertificateToken trustAnchor) {
        return this.getServiceSupplyPoints(trustAnchor, "crl", "certificateRevocationList");
    }

    private List<String> getServiceSupplyPoints(CertificateToken trustAnchor, String ... keywords) {
        ArrayList<String> urls = new ArrayList<String>();
        List<TrustProperties> trustPropertiesList = this.getTrustServices(trustAnchor);
        for (TrustProperties trustProperties : trustPropertiesList) {
            for (TrustServiceStatusAndInformationExtensions statusAndInfo : trustProperties.getTrustService()) {
                List<String> serviceSupplyPoints = statusAndInfo.getServiceSupplyPoints();
                if (!Utils.isCollectionNotEmpty(serviceSupplyPoints)) continue;
                for (String serviceSupplyPoint : serviceSupplyPoints) {
                    for (String keyword : keywords) {
                        if (!serviceSupplyPoint.contains(keyword)) continue;
                        LOG.debug("ServiceSupplyPoints (TL) found for keyword '{}'", (Object)keyword);
                        urls.add(serviceSupplyPoint);
                    }
                }
            }
        }
        return urls;
    }

    public int getNumberOfTrustedPublicKeys() {
        return this.trustPropertiesByEntity.size();
    }
}

