/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.EnumMap;

public abstract class CommonDocument
implements DSSDocument {
    protected EnumMap<DigestAlgorithm, byte[]> digestMap = new EnumMap(DigestAlgorithm.class);
    protected MimeType mimeType;
    protected String name;

    protected CommonDocument() {
    }

    @Override
    public void save(String path) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(path);){
            this.writeTo(fos);
        }
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        byte[] buffer = new byte[8192];
        int count = -1;
        try (InputStream inStream = this.openStream();){
            while ((count = inStream.read(buffer)) > 0) {
                stream.write(buffer, 0, count);
            }
        }
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Deprecated
    public String getDigest(DigestAlgorithm digestAlgorithm) {
        byte[] digestBytes = this.getDigestValue(digestAlgorithm);
        return Base64.getEncoder().encodeToString(digestBytes);
    }

    @Override
    public byte[] getDigestValue(DigestAlgorithm digestAlgorithm) {
        byte[] digest = this.digestMap.get(digestAlgorithm);
        if (digest == null) {
            try (InputStream is = this.openStream();){
                int count;
                MessageDigest messageDigest = digestAlgorithm.getMessageDigest();
                byte[] buffer = new byte[8192];
                while ((count = is.read(buffer)) > 0) {
                    messageDigest.update(buffer, 0, count);
                }
                digest = messageDigest.digest();
                this.digestMap.put(digestAlgorithm, digest);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new DSSException("Unable to compute the digest", e);
            }
        }
        return digest;
    }

    public String toString() {
        String mimeTypeString = this.mimeType == null ? "" : this.mimeType.getMimeTypeString();
        return "Name: " + this.name + " / MimeType: " + mimeTypeString;
    }
}

