/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.scope;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.identifier.DataIdentifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public abstract class SignatureScope
implements IdentifierBasedObject,
Serializable {
    private static final long serialVersionUID = -5579782848203348145L;
    private final String name;
    private final DSSDocument document;
    private DataIdentifier dssId;
    private List<SignatureScope> children;

    protected SignatureScope(DSSDocument document) {
        this(document.getName(), document);
    }

    protected SignatureScope(String name, DSSDocument document) {
        this.name = name;
        this.document = document;
    }

    public String getDocumentName() {
        return this.name;
    }

    public String getName(TokenIdentifierProvider tokenIdentifierProvider) {
        return this.getDocumentName();
    }

    public Digest getDigest(DigestAlgorithm digestAlgorithm) {
        if (this.document != null) {
            if (this.document instanceof DigestDocument) {
                return ((DigestDocument)this.document).getExistingDigest();
            }
            return new Digest(digestAlgorithm, Base64.getDecoder().decode(this.document.getDigest(digestAlgorithm)));
        }
        return null;
    }

    public abstract String getDescription(TokenIdentifierProvider var1);

    public List<String> getTransformations() {
        return null;
    }

    public abstract SignatureScopeType getType();

    public List<SignatureScope> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<SignatureScope>();
        }
        return this.children;
    }

    public void addChildSignatureScope(SignatureScope signatureScope) {
        this.getChildren().add(signatureScope);
    }

    @Override
    public DataIdentifier getDSSId() {
        if (this.dssId == null) {
            this.dssId = new DataIdentifier(this.name, this.document);
        }
        return this.dssId;
    }

    public String getDSSIdAsString() {
        return this.getDSSId().asXmlId();
    }

    public String toString() {
        return "SignatureScope{name='" + this.name + '\'' + ", document=" + this.document + ", dssId=" + this.dssId + ", children=" + this.children + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SignatureScope)) {
            return false;
        }
        SignatureScope s = (SignatureScope)obj;
        return this.getDSSId().equals(s.getDSSId());
    }

    public int hashCode() {
        return this.getDSSId().hashCode();
    }
}

