/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import java.util.Objects;

public abstract class TimestampParameters
implements SerializableTimestampParameters {
    protected DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA256;

    protected TimestampParameters() {
    }

    protected TimestampParameters(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampParameters other = (TimestampParameters)obj;
        return this.digestAlgorithm == other.digestAlgorithm;
    }

    public String toString() {
        return "TimestampParameters {digestAlgorithm=" + this.digestAlgorithm.getName() + "}";
    }
}

