/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import java.util.ArrayList;
import java.util.List;

public enum ServiceQualification {
    QC_STATEMENT("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCStatement"),
    NOT_QUALIFIED("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/NotQualified"),
    QC_WITH_SSCD("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithSSCD"),
    QC_WITH_QSCD("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD"),
    QC_NO_SSCD("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoSSCD"),
    QC_NO_QSCD("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD"),
    QC_SSCD_STATUS_AS_IN_CERT("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCSSCDStatusAsInCert"),
    QC_QSCD_STATUS_AS_IN_CERT("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert"),
    QC_QSCD_MANAGED_ON_BEHALF("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf"),
    QC_FOR_LEGAL_PERSON("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForLegalPerson"),
    QC_FOR_ESIG("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESig"),
    QC_FOR_ESEAL("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESeal"),
    QC_FOR_WSA("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForWSA");

    private final String uri;

    private ServiceQualification(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public static ServiceQualification getByUri(String uri) {
        if (uri != null) {
            for (ServiceQualification serviceQualification : ServiceQualification.values()) {
                if (!uri.equals(serviceQualification.getUri())) continue;
                return serviceQualification;
            }
        }
        return null;
    }

    public static boolean isQcStatement(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_STATEMENT);
    }

    public static boolean isNotQualified(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, NOT_QUALIFIED);
    }

    public static boolean isQcNoQSCD(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_NO_QSCD);
    }

    public static boolean isQcNoSSCD(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_NO_SSCD);
    }

    public static boolean isQcForLegalPerson(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_FOR_LEGAL_PERSON);
    }

    public static boolean isQcQSCDStatusAsInCert(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_QSCD_STATUS_AS_IN_CERT);
    }

    public static boolean isQcSSCDStatusAsInCert(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_SSCD_STATUS_AS_IN_CERT);
    }

    public static boolean isQcQSCDManagedOnBehalf(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_QSCD_MANAGED_ON_BEHALF);
    }

    public static boolean isQcWithQSCD(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_WITH_QSCD);
    }

    public static boolean isQcWithSSCD(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_WITH_SSCD);
    }

    public static boolean isQcForEsig(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_FOR_ESIG);
    }

    public static boolean isQcForEseal(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_FOR_ESEAL);
    }

    public static boolean isQcForWSA(List<String> qualifiers) {
        return ServiceQualification.listContains(qualifiers, QC_FOR_WSA);
    }

    public static List<String> getUsageQualifiers(List<String> qualifiers) {
        ArrayList<String> filteredQualifiers = new ArrayList<String>();
        if (qualifiers != null && !qualifiers.isEmpty()) {
            if (qualifiers.contains(QC_FOR_ESIG.getUri())) {
                filteredQualifiers.add(QC_FOR_ESIG.getUri());
            }
            if (qualifiers.contains(QC_FOR_ESEAL.getUri())) {
                filteredQualifiers.add(QC_FOR_ESEAL.getUri());
            }
            if (qualifiers.contains(QC_FOR_WSA.getUri())) {
                filteredQualifiers.add(QC_FOR_WSA.getUri());
            }
        }
        return filteredQualifiers;
    }

    private static boolean listContains(List<String> qualifiers, ServiceQualification ... expecteds) {
        if (qualifiers != null && !qualifiers.isEmpty()) {
            for (ServiceQualification expected : expecteds) {
                if (!qualifiers.contains(expected.getUri())) continue;
                return true;
            }
        }
        return false;
    }
}

