/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.evidencerecord;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.validation.evidencerecord.EvidenceRecordValidatorFactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class EvidenceRecordValidator
extends SignedDocumentValidator {
    private EvidenceRecord evidenceRecord;

    protected EvidenceRecordValidator() {
    }

    protected EvidenceRecordValidator(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be validated cannot be null!");
        this.document = document;
    }

    public static EvidenceRecordValidator fromDocument(DSSDocument dssDocument) {
        return EvidenceRecordValidatorFactory.fromDocument(dssDocument);
    }

    public EvidenceRecord getEvidenceRecord() {
        if (this.evidenceRecord == null) {
            this.evidenceRecord = this.buildEvidenceRecord();
            List<SignatureScope> evidenceRecordScopes = this.getEvidenceRecordScopes(this.evidenceRecord);
            this.evidenceRecord.setEvidenceRecordScopes(evidenceRecordScopes);
            this.evidenceRecord.setTimestampedReferences(this.getTimestampedReferences(evidenceRecordScopes));
        }
        return this.evidenceRecord;
    }

    protected abstract EvidenceRecord buildEvidenceRecord();

    @Override
    public List<EvidenceRecord> getDetachedEvidenceRecords() {
        return Collections.singletonList(this.getEvidenceRecord());
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        throw new UnsupportedOperationException("getOriginalDocuments(AdvancedSignature) is not supported for EvidenceRecordValidator!");
    }
}

