/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.spi.DSSASN1Utils;
import java.io.Serializable;
import java.util.Comparator;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.tsp.TimeStampToken;

public class TimeStampTokenProductionComparator
implements Comparator<TimeStampToken>,
Serializable {
    private static final long serialVersionUID = 4125423970411266861L;

    @Override
    public int compare(TimeStampToken timeStampTokenOne, TimeStampToken timeStampTokenTwo) {
        int result = DSSASN1Utils.getTimeStampTokenGenerationTime((TimeStampToken)timeStampTokenOne).compareTo(DSSASN1Utils.getTimeStampTokenGenerationTime((TimeStampToken)timeStampTokenTwo));
        if (result == 0) {
            ASN1Sequence atsHashIndexOne = DSSASN1Utils.getAtsHashIndex((AttributeTable)timeStampTokenOne.getUnsignedAttributes());
            ASN1Sequence atsHashIndexTwo = DSSASN1Utils.getAtsHashIndex((AttributeTable)timeStampTokenTwo.getUnsignedAttributes());
            if (atsHashIndexOne != null && atsHashIndexTwo != null) {
                int hashTableSizeTwo;
                int hashTableSizeOne = this.getHashTableSize(atsHashIndexOne);
                if (hashTableSizeOne < (hashTableSizeTwo = this.getHashTableSize(atsHashIndexTwo))) {
                    result = -1;
                } else if (hashTableSizeOne > hashTableSizeTwo) {
                    result = 1;
                }
            }
        }
        return result;
    }

    public boolean after(TimeStampToken timeStampTokenOne, TimeStampToken timeStampTokenTwo) {
        return this.compare(timeStampTokenOne, timeStampTokenTwo) == 1;
    }

    private int getHashTableSize(ASN1Sequence derSequence) {
        int recordsNumber = 0;
        for (int ii = 0; ii < derSequence.size(); ++ii) {
            ASN1Sequence derEncodedSequence = (ASN1Sequence)derSequence.getObjectAt(ii);
            recordsNumber += derEncodedSequence.size();
        }
        return recordsNumber;
    }
}

