/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt;

import edu.vt.middleware.crypt.AbstractCli;
import edu.vt.middleware.crypt.CryptProvider;
import edu.vt.middleware.crypt.digest.MD5;
import edu.vt.middleware.crypt.digest.SHA1;
import edu.vt.middleware.crypt.util.Converter;
import edu.vt.middleware.crypt.util.CryptReader;
import edu.vt.middleware.crypt.util.CryptWriter;
import edu.vt.middleware.crypt.util.HexConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class KeyStoreCli
extends AbstractCli {
    public static final String DEFAULT_KEY_ALGORITHM = "RSA";
    protected static final String OPT_LIST = "list";
    protected static final String OPT_IMPORT = "import";
    protected static final String OPT_EXPORT = "export";
    protected static final String OPT_STORE = "keystore";
    protected static final String OPT_TYPE = "storetype";
    protected static final String OPT_PASS = "storepass";
    protected static final String OPT_ALIAS = "alias";
    protected static final String OPT_CERT = "cert";
    protected static final String OPT_KEY = "key";
    protected static final String OPT_KEYALG = "keyalg";
    private static final String COMMAND_NAME = "keystore";
    private final MD5 md5 = new MD5();
    private final SHA1 sha1 = new SHA1();
    private final HexConverter hexConv = new HexConverter(true);

    public static void main(String[] args) {
        new KeyStoreCli().performAction(args);
    }

    protected void initOptions() {
        super.initOptions();
        Option keystore = new Option("keystore", true, "keystore file");
        keystore.setArgName("filepath");
        keystore.setOptionalArg(false);
        Option pass = new Option(OPT_PASS, true, "keystore password");
        pass.setArgName("password");
        pass.setOptionalArg(false);
        Option type = new Option(OPT_TYPE, true, "keystore type, e.g. BKS (default), JKS");
        type.setArgName("name");
        type.setOptionalArg(false);
        Option alias = new Option(OPT_ALIAS, true, "alias assigned to imported item or alias of item to export");
        alias.setArgName("name");
        alias.setOptionalArg(false);
        Option cert = new Option(OPT_CERT, true, "X.509 certificate file; encoding determined by file extension (der|pem)");
        cert.setArgName("filepath");
        cert.setOptionalArg(false);
        Option key = new Option(OPT_KEY, true, "DER-encoded PKCS#8 or PEM-encoded SSLeay private key; encoding determined by file extension (der|pem)");
        key.setArgName("filepath");
        key.setOptionalArg(false);
        Option keyalg = new Option(OPT_KEYALG, true, "private key algorithm name; assumes RSA if not specified");
        keyalg.setArgName("algorithm");
        keyalg.setOptionalArg(false);
        this.options.addOption(keystore);
        this.options.addOption(pass);
        this.options.addOption(type);
        this.options.addOption(alias);
        this.options.addOption(cert);
        this.options.addOption(key);
        this.options.addOption(keyalg);
        this.options.addOption(new Option(OPT_LIST, "list keystore contents"));
        this.options.addOption(new Option(OPT_IMPORT, "import cert or cert/key pair"));
        this.options.addOption(new Option(OPT_EXPORT, "export cert or cert/key pair"));
    }

    protected void dispatch(CommandLine line) throws Exception {
        if (line.hasOption(OPT_LIST)) {
            this.list(line);
        } else if (line.hasOption(OPT_IMPORT)) {
            this.doImport(line);
        } else if (line.hasOption(OPT_EXPORT)) {
            this.doExport(line);
        } else {
            this.printHelp();
        }
    }

    protected void list(CommandLine line) throws Exception {
        this.validateOptions(line);
        KeyStore store = this.readKeyStore(line);
        Enumeration<String> aliases = store.aliases();
        System.out.println("");
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            System.out.println("Alias name: " + alias);
            System.out.println("Creation date: " + store.getCreationDate(alias));
            if (store.isKeyEntry(alias)) {
                System.out.println("Entry type: keyEntry");
                Certificate[] chain = store.getCertificateChain(alias);
                System.out.println("Certificate chain length: " + chain.length);
                for (int i = 0; i < chain.length; ++i) {
                    System.out.println("===== Certificate [" + i + "] =====");
                    this.printCertificate(chain[i]);
                }
            } else {
                System.out.println("Entry type: trustedCertEntry");
                System.out.println("Certificate details:");
                this.printCertificate(store.getCertificate(alias));
            }
            System.out.println("");
            System.out.println("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImport(CommandLine line) throws Exception {
        this.validateOptions(line);
        KeyStore store = this.readKeyStore(line);
        String alias = line.getOptionValue(OPT_ALIAS);
        File certFile = new File(line.getOptionValue(OPT_CERT));
        if (line.hasOption(OPT_KEY)) {
            File keyFile = new File(line.getOptionValue(OPT_KEY));
            char[] passChars = line.getOptionValue(OPT_PASS).toCharArray();
            PrivateKey key = CryptReader.readPrivateKey(keyFile);
            Certificate[] chain = CryptReader.readCertificateChain(certFile);
            System.err.println("Read certificate chain of length " + chain.length + ":");
            for (int i = 0; i < chain.length; ++i) {
                System.out.println("===== Certificate [" + i + "] =====");
                this.printCertificate(chain[i]);
            }
            store.setKeyEntry(alias, key, passChars, chain);
            System.err.println("Imported key entry " + alias);
        } else {
            Certificate cert = CryptReader.readCertificate(certFile);
            System.err.println("Read certificate:");
            this.printCertificate(cert);
            store.setCertificateEntry(alias, cert);
            System.err.println("Imported trusted cert entry " + alias);
        }
        FileOutputStream os = new FileOutputStream(new File(line.getOptionValue("keystore")));
        try {
            store.store(os, line.getOptionValue(OPT_PASS).toCharArray());
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    protected void doExport(CommandLine line) throws Exception {
        this.validateOptions(line);
        KeyStore store = this.readKeyStore(line);
        String alias = line.getOptionValue(OPT_ALIAS);
        boolean wroteData = false;
        if (line.hasOption(OPT_CERT)) {
            File certFile = new File(line.getOptionValue(OPT_CERT));
            Certificate[] certs = store.getCertificateChain(alias);
            if (certs != null) {
                if (certFile.getName().endsWith("pem")) {
                    CryptWriter.writePemCertificates(certs, certFile);
                } else {
                    CryptWriter.writeEncodedCertificates(certs, certFile);
                }
            } else {
                Certificate cert = store.getCertificate(alias);
                if (certFile.getName().endsWith("pem")) {
                    CryptWriter.writePemCertificate(cert, certFile);
                } else {
                    CryptWriter.writeEncodedCertificate(cert, certFile);
                }
            }
            System.err.println("Wrote certificate to " + certFile);
            wroteData = true;
        }
        if (line.hasOption(OPT_KEY)) {
            File keyFile = new File(line.getOptionValue(OPT_KEY));
            PrivateKey key = (PrivateKey)store.getKey(alias, line.getOptionValue(OPT_PASS).toCharArray());
            if (keyFile.getName().endsWith("pem")) {
                CryptWriter.writePemKey(key, null, null, keyFile);
            } else {
                CryptWriter.writeEncodedKey((Key)key, keyFile);
            }
            System.err.println("Wrote key to " + keyFile);
            wroteData = true;
        }
        if (!wroteData) {
            System.err.println("No data was written because neither -cert nor -key was specified.");
        }
    }

    protected String getCommandName() {
        return "keystore";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyStore readKeyStore(CommandLine line) throws Exception {
        KeyStore store = null;
        store = line.hasOption(OPT_TYPE) ? CryptProvider.getKeyStore(line.getOptionValue(OPT_TYPE)) : CryptProvider.getKeyStore();
        File storeFile = new File(line.getOptionValue("keystore"));
        char[] passChars = line.getOptionValue(OPT_PASS).toCharArray();
        if (storeFile.exists()) {
            FileInputStream in = new FileInputStream(storeFile);
            try {
                store.load(in, passChars);
            }
            finally {
                ((InputStream)in).close();
            }
        } else if (line.hasOption(OPT_IMPORT)) {
            store.load(null, passChars);
        } else {
            throw new IllegalArgumentException("Keystore does not exist at " + storeFile + ". " + "An existing keystore is required for this operation.");
        }
        return store;
    }

    protected void printCertificate(Certificate cert) throws Exception {
        if (cert instanceof X509Certificate) {
            X509Certificate xCert = (X509Certificate)cert;
            byte[] encodedCert = xCert.getEncoded();
            System.out.println("Subject: " + xCert.getSubjectDN());
            System.out.println("Issuer: " + xCert.getIssuerDN());
            System.out.println("Serial: " + this.hexConv.fromBytes(xCert.getSerialNumber().toByteArray()));
            System.out.println("Valid not before: " + xCert.getNotBefore());
            System.out.println("Valid not after: " + xCert.getNotAfter());
            System.out.println("MD5 fingerprint: " + this.md5.digest(encodedCert, (Converter)this.hexConv));
            System.out.println("SHA1 fingerprint: " + this.sha1.digest(encodedCert, (Converter)this.hexConv));
        } else {
            System.out.println(cert);
        }
    }

    protected void validateOptions(CommandLine line) {
        if (!line.hasOption("keystore")) {
            throw new IllegalArgumentException("keystore option is required.");
        }
        if (!line.hasOption(OPT_PASS)) {
            throw new IllegalArgumentException("storepass option is required.");
        }
        if ((line.hasOption(OPT_IMPORT) || line.hasOption(OPT_EXPORT)) && !line.hasOption(OPT_ALIAS)) {
            throw new IllegalArgumentException("alias option is required.");
        }
        if (line.hasOption(OPT_IMPORT) && !line.hasOption(OPT_CERT)) {
            throw new IllegalArgumentException("cert option is required.");
        }
    }
}

