/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.util;

import dev.miku.r2dbc.mysql.util.ArrItr;
import dev.miku.r2dbc.mysql.util.ArrList;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class InternalArrays {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final String[] EMPTY_STRINGS = new String[0];

    @SafeVarargs
    public static <E> List<E> asImmutableList(E ... a) {
        AssertUtils.requireNonNull(a, "array must not be null");
        switch (a.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(a[0]);
            }
        }
        return new ArrList<E>(a);
    }

    @SafeVarargs
    public static <E> List<E> toImmutableList(E ... a) {
        AssertUtils.requireNonNull(a, "array must not be null");
        switch (a.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(a[0]);
            }
        }
        return new ArrList<E>(Arrays.copyOf(a, a.length));
    }

    @SafeVarargs
    public static <E> Iterator<E> asIterator(E ... a) {
        AssertUtils.requireNonNull(a, "array must not be null");
        if (a.length == 0) {
            return Collections.emptyIterator();
        }
        return new ArrItr<E>(0, a);
    }

    private InternalArrays() {
    }
}

