/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.DecodeContext;
import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.message.server.EofMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

abstract class MetadataDecodeContext
implements DecodeContext {
    private static final Logger logger = LoggerFactory.getLogger(MetadataDecodeContext.class);
    private final boolean deprecateEof;

    MetadataDecodeContext(boolean deprecateEof) {
        this.deprecateEof = deprecateEof;
    }

    abstract boolean isInMetadata();

    @Nullable
    final SyntheticMetadataMessage putPart(ServerMessage message) {
        if (message instanceof DefinitionMetadataMessage) {
            int index = this.putMetadata((DefinitionMetadataMessage)message);
            if (this.deprecateEof) {
                SyntheticMetadataMessage bundle = this.checkComplete(index, null);
                if (bundle != null) {
                    logger.debug("Respond a metadata bundle by filled-up");
                }
                return bundle;
            }
            return null;
        }
        if (message instanceof EofMessage) {
            if (this.deprecateEof) {
                throw new IllegalStateException(String.format("Unexpected %s because server has deprecated EOF", message));
            }
            int currentIndex = this.currentIndex();
            SyntheticMetadataMessage bundle = this.checkComplete(currentIndex, (EofMessage)message);
            if (bundle == null) {
                if (logger.isErrorEnabled()) {
                    logger.error("Unexpected {} when metadata unfilled, fill index: {}, checkpoint(s): {}", new Object[]{message, currentIndex, this.loggingPoints()});
                }
            } else {
                logger.debug("Respond a metadata bundle by {}", (Object)message);
            }
            return bundle;
        }
        throw new IllegalStateException(String.format("Unknown message type %s when reading metadata", message.getClass().getSimpleName()));
    }

    @Nullable
    protected abstract SyntheticMetadataMessage checkComplete(int var1, @Nullable EofMessage var2);

    protected abstract int putMetadata(DefinitionMetadataMessage var1);

    protected abstract int currentIndex();

    protected abstract Object loggingPoints();
}

