/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class ErrorMessage
implements ServerMessage {
    private static final int SQL_STATE_SIZE = 5;
    private final int errorCode;
    @Nullable
    private final String sqlState;
    private final String errorMessage;

    private ErrorMessage(int errorCode, @Nullable String sqlState, String errorMessage) {
        this.errorCode = errorCode;
        this.sqlState = sqlState;
        this.errorMessage = AssertUtils.requireNonNull(errorMessage, "error message must not be null");
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public String getSqlState() {
        return this.sqlState;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static ErrorMessage decode(ByteBuf buf) {
        String sqlState;
        buf.skipBytes(1);
        int errorCode = buf.readUnsignedShortLE();
        if (35 == buf.getByte(buf.readerIndex())) {
            buf.skipBytes(1);
            sqlState = buf.toString(buf.readerIndex(), 5, StandardCharsets.US_ASCII);
            buf.skipBytes(5);
        } else {
            sqlState = null;
        }
        return new ErrorMessage(errorCode, sqlState, buf.toString(StandardCharsets.US_ASCII));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage that = (ErrorMessage)o;
        if (this.errorCode != that.errorCode) {
            return false;
        }
        if (!Objects.equals(this.sqlState, that.sqlState)) {
            return false;
        }
        return this.errorMessage.equals(that.errorMessage);
    }

    public int hashCode() {
        int result = this.errorCode;
        result = 31 * result + (this.sqlState != null ? this.sqlState.hashCode() : 0);
        result = 31 * result + this.errorMessage.hashCode();
        return result;
    }

    public String toString() {
        return String.format("ErrorMessage{errorCode=%d, sqlState='%s', errorMessage='%s'}", this.errorCode, this.sqlState, this.errorMessage);
    }
}

