/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

interface ByteBufJoiner {
    public ByteBuf join(List<ByteBuf> var1);

    public static ByteBufJoiner wrapped() {
        return parts -> {
            int size = parts.size();
            switch (size) {
                case 0: {
                    throw new IllegalStateException("No buffer available");
                }
                case 1: {
                    try {
                        ByteBuf byteBuf = (ByteBuf)parts.get(0);
                        return byteBuf;
                    }
                    finally {
                        parts.clear();
                    }
                }
            }
            CompositeByteBuf composite = null;
            try {
                composite = ((ByteBuf)parts.get(0)).alloc().compositeBuffer(size);
                CompositeByteBuf compositeByteBuf = composite.addComponents(true, (Iterable)parts);
                return compositeByteBuf;
            }
            catch (Throwable e) {
                if (composite == null) {
                    for (ByteBuf part : parts) {
                        ReferenceCountUtil.safeRelease((Object)part);
                    }
                } else {
                    composite.release();
                }
                throw e;
            }
            finally {
                parts.clear();
            }
        };
    }
}

