/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.collation;

import dev.miku.r2dbc.mysql.collation.AbstractCharsetTarget;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.nio.charset.Charset;

final class CachedCharsetTarget
extends AbstractCharsetTarget {
    private final Charset charset;

    CachedCharsetTarget(int byteSize, Charset charset) {
        super(byteSize);
        this.charset = AssertUtils.requireNonNull(charset, "charset must not be null");
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachedCharsetTarget)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CachedCharsetTarget that = (CachedCharsetTarget)o;
        return this.charset.equals(that.charset);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.charset.hashCode();
        return result;
    }

    public String toString() {
        return String.format("CachedCharsetTarget{charset=%s, byteSize=%d}", this.charset, this.byteSize);
    }
}

