/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import reactor.core.publisher.Mono;

final class StringCodec
extends AbstractClassedCodec<String> {
    StringCodec(ByteBufAllocator allocator) {
        super(allocator, String.class);
    }

    @Override
    public String decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return "";
        }
        return value.toString(CharCollation.fromId(info.getCollationId(), context.getServerVersion()).getCharset());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof CharSequence;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new StringParameter(this.allocator, (CharSequence)value, context);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return (TypePredicates.isString(type) || TypePredicates.isLob(type)) && info.getCollationId() != CharCollation.BINARY_ID;
    }

    static ByteBuf encodeCharSequence(ByteBufAllocator allocator, CharSequence value, CodecContext context) {
        int length = value.length();
        if (length <= 0) {
            return allocator.buffer(1).writeByte(0);
        }
        Charset charset = context.getClientCollation().getCharset();
        ByteBuf content = allocator.buffer();
        try {
            VarIntUtils.reserveVarInt(content);
            return VarIntUtils.setReservedVarInt(content, content.writeCharSequence(value, charset));
        }
        catch (Throwable e) {
            content.release();
            throw e;
        }
    }

    private static class StringParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final CharSequence value;
        private final CodecContext context;

        private StringParameter(ByteBufAllocator allocator, CharSequence value, CodecContext context) {
            this.allocator = allocator;
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> StringCodec.encodeCharSequence(this.allocator, this.value, this.context));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.append(this.value));
        }

        @Override
        public short getType() {
            return 15;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringParameter)) {
                return false;
            }
            StringParameter that = (StringParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

