/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.DateTimes;
import dev.miku.r2dbc.mysql.codec.DurationCodec;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.LocalTime;
import reactor.core.publisher.Mono;

final class LocalTimeCodec
extends AbstractClassedCodec<LocalTime> {
    private static final long NANOS_OF_DAY = 86400000000000L;
    private static final long NANOS_OF_HOUR = 3600000000000L;
    private static final long NANOS_OF_MINUTE = 60000000000L;

    LocalTimeCodec(ByteBufAllocator allocator) {
        super(allocator, LocalTime.class);
    }

    @Override
    public LocalTime decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        return LocalTimeCodec.decodeOrigin(binary, value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof LocalTime;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new LocalTimeParameter(this.allocator, (LocalTime)value);
    }

    @Override
    public boolean doCanDecode(FieldInformation info) {
        return 11 == info.getType();
    }

    static LocalTime decodeOrigin(boolean binary, ByteBuf value) {
        return binary ? LocalTimeCodec.decodeBinary(value) : LocalTimeCodec.readTimeText(value);
    }

    static LocalTime readTimeText(ByteBuf buf) {
        boolean isNegative = LocalTimeCodec.readNegative(buf);
        int hour = DateTimes.readIntInDigits(buf);
        int minute = DateTimes.readIntInDigits(buf);
        int second = DateTimes.readIntInDigits(buf);
        if (buf.isReadable()) {
            int nano = DateTimes.readMicroInDigits(buf) * 1000;
            if (isNegative) {
                return LocalTimeCodec.negativeCircle(hour, minute, second, nano);
            }
            return LocalTime.of(hour % 24, minute, second, nano);
        }
        if (isNegative) {
            return LocalTimeCodec.negativeCircle(hour, minute, second);
        }
        return LocalTime.of(hour % 24, minute, second);
    }

    static boolean readNegative(ByteBuf buf) {
        switch (buf.getByte(buf.readerIndex())) {
            case 45: {
                buf.skipBytes(1);
                return true;
            }
            case 43: {
                buf.skipBytes(1);
                return false;
            }
        }
        return false;
    }

    private static LocalTime decodeBinary(ByteBuf buf) {
        int bytes = buf.readableBytes();
        if (bytes < 8) {
            return LocalTime.MIDNIGHT;
        }
        boolean isNegative = buf.readBoolean();
        buf.skipBytes(4);
        byte hour = buf.readByte();
        byte minute = buf.readByte();
        byte second = buf.readByte();
        if (bytes < 12) {
            if (isNegative) {
                return LocalTimeCodec.negativeCircle(hour, minute, second);
            }
            return LocalTime.of(hour % 24, minute, second);
        }
        long nano = buf.readUnsignedIntLE() * 1000L;
        if (isNegative) {
            return LocalTimeCodec.negativeCircle(hour, minute, second, nano);
        }
        return LocalTime.of(hour % 24, minute, second, (int)nano);
    }

    static ByteBuf encodeBinary(ByteBufAllocator alloc, LocalTime time) {
        if (LocalTime.MIDNIGHT.equals(time)) {
            return alloc.buffer(1).writeByte(0);
        }
        int nanos = time.getNano();
        int size = nanos > 0 ? 12 : 8;
        ByteBuf buf = alloc.buffer(1 + size);
        try {
            buf.writeByte(size).writeBoolean(false).writeIntLE(0).writeByte(time.getHour()).writeByte(time.getMinute()).writeByte(time.getSecond());
            if (nanos > 0) {
                return buf.writeIntLE(nanos / 1000);
            }
            return buf;
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    static void encodeTime(ParameterWriter writer, LocalTime time) {
        int micros = time.getNano() / 1000;
        DurationCodec.encodeTime(writer, false, time.getHour(), time.getMinute(), time.getSecond(), micros);
    }

    private static LocalTime negativeCircle(int hour, int minute, int second) {
        int total = -(hour * 3600 + minute * 60 + second);
        return LocalTime.ofSecondOfDay((total % 86400 + 86400) % 86400);
    }

    private static LocalTime negativeCircle(long hour, long minute, long second, long nano) {
        long total = -(hour * 3600000000000L + minute * 60000000000L + second * 1000000000L + nano);
        return LocalTime.ofNanoOfDay((total % 86400000000000L + 86400000000000L) % 86400000000000L);
    }

    private static final class LocalTimeParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final LocalTime value;

        private LocalTimeParameter(ByteBufAllocator allocator, LocalTime value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> LocalTimeCodec.encodeBinary(this.allocator, this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalTimeCodec.encodeTime(writer, this.value));
        }

        @Override
        public short getType() {
            return 11;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalTimeParameter)) {
                return false;
            }
            LocalTimeParameter that = (LocalTimeParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

