/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class FloatCodec
extends AbstractPrimitiveCodec<Float> {
    FloatCodec(ByteBufAllocator allocator) {
        super(allocator, Float.TYPE, Float.class);
    }

    @Override
    public Float decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (binary && info.getType() == 4) {
            return Float.valueOf(value.readFloatLE());
        }
        return Float.valueOf(Float.parseFloat(value.toString(StandardCharsets.US_ASCII)));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Float;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new FloatParameter(this.allocator, ((Float)value).floatValue());
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return 4 == type || info.getSize() < 7L && TypePredicates.isDecimal(type);
    }

    private static final class FloatParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final float value;

        private FloatParameter(ByteBufAllocator allocator, float value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                ByteBuf buf = this.allocator.buffer(4);
                try {
                    return buf.writeFloatLE(this.value);
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeFloat(this.value));
        }

        @Override
        public short getType() {
            return 4;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FloatParameter)) {
                return false;
            }
            FloatParameter that = (FloatParameter)o;
            return Float.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
        }
    }
}

