/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class DoubleCodec
extends AbstractPrimitiveCodec<Double> {
    DoubleCodec(ByteBufAllocator allocator) {
        super(allocator, Double.TYPE, Double.class);
    }

    @Override
    public Double decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (binary) {
            switch (info.getType()) {
                case 5: {
                    return value.readDoubleLE();
                }
                case 4: {
                    return value.readFloatLE();
                }
            }
        }
        return Double.parseDouble(value.toString(StandardCharsets.US_ASCII));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Double;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new DoubleParameter(this.allocator, (Double)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return 5 == type || 4 == type || info.getSize() < 16L && TypePredicates.isDecimal(type);
    }

    private static final class DoubleParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final double value;

        private DoubleParameter(ByteBufAllocator allocator, double value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                ByteBuf buf = this.allocator.buffer(8);
                try {
                    return buf.writeDoubleLE(this.value);
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeDouble(this.value));
        }

        @Override
        public short getType() {
            return 5;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DoubleParameter)) {
                return false;
            }
            DoubleParameter that = (DoubleParameter)o;
            return Double.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.value);
            return (int)(temp ^ temp >>> 32);
        }
    }
}

