/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import dev.miku.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;
import reactor.core.publisher.Mono;

final class ByteArrayCodec
extends AbstractClassedCodec<byte[]> {
    ByteArrayCodec(ByteBufAllocator allocator) {
        super(allocator, byte[].class);
    }

    @Override
    public byte[] decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return InternalArrays.EMPTY_BYTES;
        }
        return ByteBufUtil.getBytes((ByteBuf)value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof byte[];
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new ByteArrayParameter(this.allocator, (byte[])value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        return TypePredicates.isBinary(info.getType());
    }

    static ByteBuf encodeBytes(ByteBufAllocator alloc, byte[] value) {
        int size = value.length;
        if (size == 0) {
            return alloc.buffer(1).writeByte(0);
        }
        ByteBuf buf = alloc.buffer(VarIntUtils.varIntBytes(size) + size);
        try {
            VarIntUtils.writeVarInt(buf, size);
            return buf.writeBytes(value);
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    private static final class ByteArrayParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final byte[] value;

        private ByteArrayParameter(ByteBufAllocator allocator, byte[] value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> ByteArrayCodec.encodeBytes(this.allocator, this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeHex(this.value));
        }

        @Override
        public short getType() {
            return 251;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteArrayParameter)) {
                return false;
            }
            ByteArrayParameter that = (ByteArrayParameter)o;
            return Arrays.equals(this.value, that.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }
}

