/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ParameterIndex;
import dev.miku.r2dbc.mysql.PrepareQuery;
import dev.miku.r2dbc.mysql.SimpleQuery;
import dev.miku.r2dbc.mysql.TextQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class Query {
    Query() {
    }

    abstract int getParameters();

    abstract ParameterIndex getIndexes(String var1);

    static Query parse(String sql, boolean prepare) {
        int offset = Query.findParamMark(sql, 0);
        if (offset < 0) {
            return SimpleQuery.INSTANCE;
        }
        HashMap<String, ParameterIndex> nameKeyedParams = new HashMap<String, ParameterIndex>();
        String anyName = "";
        int lastNamedEnd = 0;
        int lastParamEnd = 0;
        int length = sql.length();
        int paramCount = 0;
        StringBuilder sqlBuilder = null;
        List<String> sqlParts = prepare ? Collections.emptyList() : new ArrayList();
        while (offset >= 0 && offset < length) {
            char now;
            if (!prepare) {
                sqlParts.add(Query.subStr(sql, lastParamEnd, offset));
            }
            ++paramCount;
            lastParamEnd = ++offset;
            if (offset < length && Character.isJavaIdentifierStart(now = sql.charAt(offset))) {
                int start = offset++;
                while (offset < length && Character.isJavaIdentifierPart(sql.charAt(offset))) {
                    ++offset;
                }
                if (prepare) {
                    if (sqlBuilder == null) {
                        sqlBuilder = new StringBuilder(sql.length() - offset + start);
                    }
                    sqlBuilder.append(sql, lastNamedEnd, start);
                }
                lastParamEnd = lastNamedEnd = offset;
                String name = Query.subStr(sql, start, offset);
                int paramIndex = paramCount - 1;
                ParameterIndex value = (ParameterIndex)nameKeyedParams.get(name);
                anyName = name;
                if (value == null) {
                    nameKeyedParams.put(name, new ParameterIndex(paramIndex));
                } else {
                    value.push(paramIndex);
                }
            }
            if (offset >= length) continue;
            offset = Query.findParamMark(sql, offset);
        }
        if (prepare) {
            String parsedSql = sqlBuilder == null ? sql : (lastNamedEnd < length ? sqlBuilder.append(sql, lastNamedEnd, length).toString() : sqlBuilder.toString());
            return new PrepareQuery(parsedSql, Query.wrap(nameKeyedParams, anyName), paramCount);
        }
        sqlParts.add(Query.subStr(sql, lastParamEnd, length));
        return new TextQuery(Query.wrap(nameKeyedParams, anyName), sqlParts);
    }

    private static int findParamMark(CharSequence sql, int offset) {
        int length = sql.length();
        block5: while (offset < length && offset >= 0) {
            char ch = sql.charAt(offset++);
            switch (ch) {
                case '/': {
                    if (offset == length || sql.charAt(offset) != '*') continue block5;
                    while (++offset < length) {
                        if (sql.charAt(offset) != '*' || offset + 1 >= length || sql.charAt(offset + 1) != '/') continue;
                        offset += 2;
                        continue block5;
                    }
                    continue block5;
                }
                case '-': {
                    if (offset == length || sql.charAt(offset) != '-') continue block5;
                    while (++offset < length) {
                        char now = sql.charAt(offset);
                        if (now != '\n' && now != '\r') continue;
                        ++offset;
                        continue block5;
                    }
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    while (offset < length) {
                        if (sql.charAt(offset++) != ch) continue;
                        if (length == offset || sql.charAt(offset) != ch) continue block5;
                        ++offset;
                    }
                    continue block5;
                }
            }
            if (ch != '?') continue;
            return offset - 1;
        }
        return -1;
    }

    private static Map<String, ParameterIndex> wrap(Map<String, ParameterIndex> map, String anyKey) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(anyKey, map.get(anyKey));
            }
        }
        return map;
    }

    private static String subStr(String sql, int start, int end) {
        if (start == end) {
            return "";
        }
        return sql.substring(start, end);
    }
}

