/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.MySqlResult;
import dev.miku.r2dbc.mysql.MySqlStatement;
import dev.miku.r2dbc.mysql.ParameterIndex;
import dev.miku.r2dbc.mysql.ParametrizedStatementSupport;
import dev.miku.r2dbc.mysql.PrepareQuery;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.util.List;
import reactor.core.publisher.Flux;

final class PrepareParametrizedStatement
extends ParametrizedStatementSupport {
    private final PrepareQuery query;
    private int fetchSize = 0;

    PrepareParametrizedStatement(Client client, Codecs codecs, ConnectionContext context, PrepareQuery query) {
        super(client, codecs, context, AssertUtils.requireNonNull(query, "query must not be null").getParameters());
        this.query = query;
    }

    @Override
    public Flux<MySqlResult> execute(List<Binding> bindings) {
        return QueryFlow.execute(this.client, this.query.getSql(), bindings, this.fetchSize).map(messages -> new MySqlResult(true, this.codecs, this.context, this.generatedKeyName, (Flux<ServerMessage>)messages));
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = rows;
        return this;
    }

    @Override
    protected ParameterIndex getIndexes(String name) {
        return this.query.getIndexes(name);
    }
}

