/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.ExceptionFactory;
import dev.miku.r2dbc.mysql.message.client.ClientMessage;
import dev.miku.r2dbc.mysql.message.client.PrepareQueryMessage;
import dev.miku.r2dbc.mysql.message.client.PreparedCloseMessage;
import dev.miku.r2dbc.mysql.message.client.PreparedFetchMessage;
import dev.miku.r2dbc.mysql.message.server.CompleteMessage;
import dev.miku.r2dbc.mysql.message.server.EofMessage;
import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.message.server.PreparedOkMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.message.server.ServerStatusMessage;
import dev.miku.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import io.netty.util.ReferenceCountUtil;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.SynchronousSink;

final class PrepareHandler
implements BiConsumer<ServerMessage, SynchronousSink<ServerMessage>>,
Predicate<ServerMessage> {
    private static final int PREPARE = 0;
    private static final int EXECUTE = 1;
    private static final int FETCH = 2;
    private final EmitterProcessor<ClientMessage> requests;
    private final String sql;
    private final Iterator<Binding> bindings;
    private final int fetchSize;
    private int mode = 0;
    private PreparedOkMessage preparedOk;
    private PreparedFetchMessage fetch;

    PrepareHandler(EmitterProcessor<ClientMessage> requests, String sql, Iterator<Binding> bindings, int fetchSize) {
        requests.onNext((Object)new PrepareQueryMessage(sql));
        this.requests = requests;
        this.sql = sql;
        this.bindings = bindings;
        this.fetchSize = fetchSize;
    }

    @Override
    public void accept(ServerMessage message, SynchronousSink<ServerMessage> sink) {
        if (message instanceof ErrorMessage) {
            sink.error((Throwable)ExceptionFactory.createException((ErrorMessage)message, this.sql));
            return;
        }
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                sink.next((Object)message);
                break;
            }
            default: {
                if (message instanceof ServerStatusMessage) {
                    short statuses = ((ServerStatusMessage)message).getServerStatuses();
                    if ((statuses & 0x80) == 0 && (statuses & 0x40) != 0) break;
                    sink.next((Object)message);
                    break;
                }
                sink.next((Object)message);
            }
        }
    }

    @Override
    public boolean test(ServerMessage message) {
        if (message instanceof ErrorMessage) {
            return true;
        }
        switch (this.mode) {
            case 0: {
                if (message instanceof PreparedOkMessage) {
                    PreparedOkMessage ok = (PreparedOkMessage)message;
                    int statementId = ok.getStatementId();
                    int columns = ok.getTotalColumns();
                    int parameters = ok.getTotalParameters();
                    this.preparedOk = ok;
                    if (columns <= -parameters) {
                        this.doNextExecute(statementId);
                    }
                } else if (message instanceof SyntheticMetadataMessage && ((SyntheticMetadataMessage)message).isCompleted()) {
                    this.doNextExecute(this.preparedOk.getStatementId());
                } else {
                    ReferenceCountUtil.safeRelease((Object)message);
                }
                return false;
            }
            case 1: {
                if (message instanceof CompleteMessage) {
                    return this.fetchOrExecDone(message);
                }
                if (message instanceof SyntheticMetadataMessage) {
                    EofMessage eof = ((SyntheticMetadataMessage)message).getEof();
                    if (eof instanceof ServerStatusMessage) {
                        if ((((ServerStatusMessage)((Object)eof)).getServerStatuses() & 0x40) != 0) {
                            this.doNextFetch();
                            return false;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
        }
        return this.fetchOrExecDone(message);
    }

    void close() {
        if (!this.requests.isTerminated()) {
            if (this.preparedOk != null) {
                this.requests.onNext((Object)new PreparedCloseMessage(this.preparedOk.getStatementId()));
            }
            this.requests.onComplete();
        }
        while (this.bindings.hasNext()) {
            this.bindings.next().clear();
        }
    }

    private void doNextExecute(int statementId) {
        Binding binding = this.bindings.next();
        this.mode = 1;
        this.requests.onNext((Object)binding.toExecuteMessage(statementId, this.fetchSize <= 0));
    }

    private void doNextFetch() {
        this.mode = 2;
        this.requests.onNext((Object)(this.fetch == null ? (this.fetch = new PreparedFetchMessage(this.preparedOk.getStatementId(), this.fetchSize)) : this.fetch));
    }

    private boolean fetchOrExecDone(ServerMessage message) {
        short statuses;
        if (!(message instanceof CompleteMessage) || !((CompleteMessage)message).isDone()) {
            return false;
        }
        if (this.requests.isTerminated()) {
            return true;
        }
        if (message instanceof ServerStatusMessage && ((statuses = ((ServerStatusMessage)message).getServerStatuses()) & 0x40) != 0 && (statuses & 0x80) == 0) {
            this.doNextFetch();
            return false;
        }
        if (this.bindings.hasNext()) {
            this.doNextExecute(this.preparedOk.getStatementId());
            return false;
        }
        return true;
    }
}

