/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

final class MySqlNames {
    static int nameSearch(String[] names, String name) {
        int size = name.length();
        return MySqlNames.binarySearch(names, name, size <= 2 || name.charAt(0) != '`' || name.charAt(size - 1) != '`');
    }

    private static int binarySearch(String[] names, String name, boolean ignoreCase) {
        int left = 0;
        int right = names.length - 1;
        int nameStart = ignoreCase ? 0 : 1;
        int nameEnd = ignoreCase ? name.length() : name.length() - 1;
        int ciResult = -1;
        while (left <= right) {
            int middle = left + right >>> 1;
            String value = names[middle];
            int compared = MySqlNames.compare0(value, name, nameStart, nameEnd);
            if (compared < 0) {
                left = middle + 1;
                if (compared != -2) continue;
                ciResult = middle;
                continue;
            }
            if (compared > 0) {
                right = middle - 1;
                if (compared != 2) continue;
                ciResult = middle;
                continue;
            }
            return middle;
        }
        return ignoreCase ? ciResult : -1;
    }

    static int compare(String left, String right) {
        return MySqlNames.compare0(left, right, 0, right.length());
    }

    private static int compare0(String left, String right, int start, int end) {
        int leftSize = left.length();
        int rightSize = end - start;
        int minSize = Math.min(leftSize, rightSize);
        int csCompared = 0;
        for (int i = 0; i < minSize; ++i) {
            char rightCh;
            char leftCh = left.charAt(i);
            if (leftCh == (rightCh = right.charAt(i + start))) continue;
            if (csCompared == 0) {
                csCompared = leftCh - rightCh;
            }
            if ((leftCh = Character.toLowerCase(leftCh)) == (rightCh = Character.toLowerCase(rightCh))) continue;
            return leftCh < rightCh ? -4 : 4;
        }
        if (leftSize != rightSize) {
            return leftSize < rightSize ? -4 : 4;
        }
        return csCompared < 0 ? -2 : (csCompared > 0 ? 2 : 0);
    }

    private MySqlNames() {
    }
}

