/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.Extensions;
import dev.miku.r2dbc.mysql.MySqlConnection;
import dev.miku.r2dbc.mysql.MySqlConnectionConfiguration;
import dev.miku.r2dbc.mysql.MySqlConnectionFactoryMetadata;
import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.codec.CodecsBuilder;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.extension.CodecRegistrar;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.unix.DomainSocketAddress;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;

public final class MySqlConnectionFactory
implements ConnectionFactory {
    private final Mono<MySqlConnection> client;

    private MySqlConnectionFactory(Mono<MySqlConnection> client) {
        this.client = client;
    }

    public Mono<MySqlConnection> create() {
        return this.client;
    }

    public ConnectionFactoryMetadata getMetadata() {
        return MySqlConnectionFactoryMetadata.INSTANCE;
    }

    public static MySqlConnectionFactory from(MySqlConnectionConfiguration configuration) {
        AssertUtils.requireNonNull(configuration, "configuration must not be null");
        return new MySqlConnectionFactory((Mono<MySqlConnection>)Mono.defer(() -> {
            Object address;
            MySqlSslConfiguration ssl;
            if (configuration.isHost()) {
                ssl = configuration.getSsl();
                address = InetSocketAddress.createUnresolved(configuration.getDomain(), configuration.getPort());
            } else {
                ssl = MySqlSslConfiguration.disabled();
                address = new DomainSocketAddress(configuration.getDomain());
            }
            String database = configuration.getDatabase();
            String user = configuration.getUser();
            CharSequence password = configuration.getPassword();
            SslMode sslMode = ssl.getSslMode();
            Predicate<String> prepare = configuration.getPreferPrepareStatement();
            ConnectionContext context = new ConnectionContext(configuration.getZeroDateOption(), configuration.getServerZoneId());
            Extensions extensions = configuration.getExtensions();
            return Client.connect(ssl, (SocketAddress)address, configuration.isTcpKeepAlive(), configuration.isTcpNoDelay(), context, configuration.getConnectTimeout()).flatMap(client -> QueryFlow.login(client, sslMode, database, user, password, context)).flatMap(client -> {
                ByteBufAllocator allocator = client.getByteBufAllocator();
                CodecsBuilder builder = Codecs.builder(allocator);
                extensions.forEach(CodecRegistrar.class, registrar -> registrar.register(allocator, builder));
                return MySqlConnection.init(client, builder.build(), context, prepare);
            });
        }));
    }
}

