/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Extensions;
import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.constant.ZeroDateOption;
import dev.miku.r2dbc.mysql.extension.Extension;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.netty.handler.ssl.SslContextBuilder;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import reactor.util.annotation.Nullable;

public final class MySqlConnectionConfiguration {
    private static final int DEFAULT_PORT = 3306;
    private static final Predicate<String> DEFAULT_SERVER_PREPARE = sql -> false;
    private final boolean isHost;
    private final String domain;
    private final int port;
    private final MySqlSslConfiguration ssl;
    private final boolean tcpKeepAlive;
    private final boolean tcpNoDelay;
    @Nullable
    private final Duration connectTimeout;
    @Nullable
    private final ZoneId serverZoneId;
    private final ZeroDateOption zeroDateOption;
    private final String user;
    @Nullable
    private final CharSequence password;
    private final String database;
    @Nullable
    private final Predicate<String> preferPrepareStatement;
    private final Extensions extensions;

    private MySqlConnectionConfiguration(boolean isHost, String domain, int port, @Nullable MySqlSslConfiguration ssl, boolean tcpKeepAlive, boolean tcpNoDelay, @Nullable Duration connectTimeout, ZeroDateOption zeroDateOption, @Nullable ZoneId serverZoneId, String user, @Nullable CharSequence password, @Nullable String database, @Nullable Predicate<String> preferPrepareStatement, Extensions extensions) {
        this.isHost = isHost;
        this.domain = domain;
        this.port = port;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.connectTimeout = connectTimeout;
        this.ssl = AssertUtils.requireNonNull(ssl, "ssl must not be null");
        this.serverZoneId = serverZoneId;
        this.zeroDateOption = AssertUtils.requireNonNull(zeroDateOption, "zeroDateOption must not be null");
        this.user = AssertUtils.requireNonNull(user, "user must not be null");
        this.password = password;
        this.database = database == null || database.isEmpty() ? "" : database;
        this.preferPrepareStatement = preferPrepareStatement;
        this.extensions = AssertUtils.requireNonNull(extensions, "extensions must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    boolean isHost() {
        return this.isHost;
    }

    String getDomain() {
        return this.domain;
    }

    int getPort() {
        return this.port;
    }

    @Nullable
    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    MySqlSslConfiguration getSsl() {
        return this.ssl;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    ZeroDateOption getZeroDateOption() {
        return this.zeroDateOption;
    }

    @Nullable
    ZoneId getServerZoneId() {
        return this.serverZoneId;
    }

    String getUser() {
        return this.user;
    }

    @Nullable
    CharSequence getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }

    @Nullable
    Predicate<String> getPreferPrepareStatement() {
        return this.preferPrepareStatement;
    }

    Extensions getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlConnectionConfiguration)) {
            return false;
        }
        MySqlConnectionConfiguration that = (MySqlConnectionConfiguration)o;
        return this.isHost == that.isHost && this.domain.equals(that.domain) && this.port == that.port && this.ssl.equals(that.ssl) && this.tcpKeepAlive == that.tcpKeepAlive && this.tcpNoDelay == that.tcpNoDelay && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.serverZoneId, that.serverZoneId) && this.zeroDateOption == that.zeroDateOption && this.user.equals(that.user) && Objects.equals(this.password, that.password) && this.database.equals(that.database) && Objects.equals(this.preferPrepareStatement, that.preferPrepareStatement) && this.extensions.equals(that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isHost, this.domain, this.port, this.ssl, this.tcpKeepAlive, this.tcpNoDelay, this.connectTimeout, this.serverZoneId, this.zeroDateOption, this.user, this.password, this.database, this.preferPrepareStatement, this.extensions});
    }

    public String toString() {
        if (this.isHost) {
            return "MySqlConnectionConfiguration{, host='" + this.domain + '\'' + ", port=" + this.port + ", ssl=" + this.ssl + ", tcpNoDelay=" + this.tcpNoDelay + ", tcpKeepAlive=" + this.tcpKeepAlive + ", connectTimeout=" + this.connectTimeout + ", serverZoneId=" + this.serverZoneId + ", zeroDateOption=" + (Object)((Object)this.zeroDateOption) + ", user='" + this.user + '\'' + ", password=" + this.password + ", database='" + this.database + '\'' + ", preferPrepareStatement=" + this.preferPrepareStatement + ", extensions=" + this.extensions + '}';
        }
        return "MySqlConnectionConfiguration{, unixSocket='" + this.domain + '\'' + ", connectTimeout=" + this.connectTimeout + ", serverZoneId=" + this.serverZoneId + ", zeroDateOption=" + (Object)((Object)this.zeroDateOption) + ", user='" + this.user + '\'' + ", password=" + this.password + ", database='" + this.database + '\'' + ", preferPrepareStatement=" + this.preferPrepareStatement + ", extensions=" + this.extensions + '}';
    }

    public static final class Builder {
        @Nullable
        private String database;
        private boolean isHost = true;
        private String domain;
        @Nullable
        private CharSequence password;
        private int port = 3306;
        @Nullable
        private Duration connectTimeout;
        private String user;
        private ZeroDateOption zeroDateOption = ZeroDateOption.USE_NULL;
        @Nullable
        private ZoneId serverZoneId;
        @Nullable
        private SslMode sslMode;
        private String[] tlsVersion = InternalArrays.EMPTY_STRINGS;
        @Nullable
        private HostnameVerifier sslHostnameVerifier;
        @Nullable
        private String sslCa;
        @Nullable
        private String sslKey;
        @Nullable
        private CharSequence sslKeyPassword;
        @Nullable
        private String sslCert;
        @Nullable
        private Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer;
        private boolean tcpKeepAlive;
        private boolean tcpNoDelay;
        @Nullable
        private Predicate<String> preferPrepareStatement;
        private boolean autodetectExtensions = true;
        private final List<Extension> extensions = new ArrayList<Extension>();

        private Builder() {
        }

        public MySqlConnectionConfiguration build() {
            SslMode sslMode = this.requireSslMode();
            if (this.isHost) {
                AssertUtils.requireNonNull(this.domain, "host must not be null when using TCP socket");
                AssertUtils.require(this.sslCert == null && this.sslKey == null || this.sslCert != null && this.sslKey != null, "sslCert and sslKey must be both null or both non-null");
            } else {
                AssertUtils.requireNonNull(this.domain, "unixSocket must not be null when using unix domain socket");
                AssertUtils.require(!sslMode.startSsl(), "sslMode must be disabled when using unix domain socket");
            }
            MySqlSslConfiguration ssl = MySqlSslConfiguration.create(sslMode, this.tlsVersion, this.sslHostnameVerifier, this.sslCa, this.sslKey, this.sslKeyPassword, this.sslCert, this.sslContextBuilderCustomizer);
            return new MySqlConnectionConfiguration(this.isHost, this.domain, this.port, ssl, this.tcpKeepAlive, this.tcpNoDelay, this.connectTimeout, this.zeroDateOption, this.serverZoneId, this.user, this.password, this.database, this.preferPrepareStatement, Extensions.from(this.extensions, this.autodetectExtensions));
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder unixSocket(String unixSocket) {
            this.domain = AssertUtils.requireNonNull(unixSocket, "unixSocket must not be null");
            this.isHost = false;
            return this;
        }

        public Builder host(String host) {
            this.domain = AssertUtils.requireNonNull(host, "host must not be null");
            this.isHost = true;
            return this;
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public Builder port(int port) {
            AssertUtils.require(port >= 0 && port <= 65535, "port must be between 0 and 65535");
            this.port = port;
            return this;
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder user(String user) {
            this.user = AssertUtils.requireNonNull(user, "user must not be null");
            return this;
        }

        public Builder username(String user) {
            return this.user(user);
        }

        public Builder serverZoneId(@Nullable ZoneId serverZoneId) {
            this.serverZoneId = serverZoneId;
            return this;
        }

        public Builder zeroDateOption(ZeroDateOption zeroDate) {
            this.zeroDateOption = AssertUtils.requireNonNull(zeroDate, "zeroDateOption must not be null");
            return this;
        }

        public Builder sslMode(SslMode sslMode) {
            this.sslMode = AssertUtils.requireNonNull(sslMode, "sslMode must not be null");
            return this;
        }

        public Builder tlsVersion(String ... tlsVersion) {
            AssertUtils.requireNonNull(tlsVersion, "tlsVersion must not be null");
            int size = tlsVersion.length;
            if (size > 0) {
                String[] versions = new String[size];
                System.arraycopy(tlsVersion, 0, versions, 0, size);
                this.tlsVersion = versions;
            } else {
                this.tlsVersion = InternalArrays.EMPTY_STRINGS;
            }
            return this;
        }

        public Builder sslHostnameVerifier(HostnameVerifier sslHostnameVerifier) {
            this.sslHostnameVerifier = AssertUtils.requireNonNull(sslHostnameVerifier, "sslHostnameVerifier must not be null");
            return this;
        }

        public Builder sslCa(@Nullable String sslCa) {
            this.sslCa = sslCa;
            return this;
        }

        public Builder sslCert(@Nullable String sslCert) {
            this.sslCert = sslCert;
            return this;
        }

        public Builder sslKey(@Nullable String sslKey) {
            this.sslKey = sslKey;
            return this;
        }

        public Builder sslKeyPassword(@Nullable CharSequence sslKeyPassword) {
            this.sslKeyPassword = sslKeyPassword;
            return this;
        }

        public Builder sslContextBuilderCustomizer(Function<SslContextBuilder, SslContextBuilder> customizer) {
            AssertUtils.requireNonNull(customizer, "sslContextBuilderCustomizer must not be null");
            this.sslContextBuilderCustomizer = customizer;
            return this;
        }

        public Builder tcpKeepAlive(boolean enabled) {
            this.tcpKeepAlive = enabled;
            return this;
        }

        public Builder tcpNoDelay(boolean enabled) {
            this.tcpNoDelay = enabled;
            return this;
        }

        public Builder useClientPrepareStatement() {
            this.preferPrepareStatement = null;
            return this;
        }

        public Builder useServerPrepareStatement() {
            return this.useServerPrepareStatement(DEFAULT_SERVER_PREPARE);
        }

        public Builder useServerPrepareStatement(Predicate<String> preferPrepareStatement) {
            AssertUtils.requireNonNull(preferPrepareStatement, "preferPrepareStatement must not be null");
            this.preferPrepareStatement = preferPrepareStatement;
            return this;
        }

        public Builder autodetectExtensions(boolean enabled) {
            this.autodetectExtensions = enabled;
            return this;
        }

        public Builder extendWith(Extension extension) {
            this.extensions.add(AssertUtils.requireNonNull(extension, "extension must not be null"));
            return this;
        }

        private SslMode requireSslMode() {
            SslMode sslMode = this.sslMode;
            if (sslMode == null) {
                sslMode = this.isHost ? SslMode.PREFERRED : SslMode.DISABLED;
            }
            return sslMode;
        }
    }
}

