/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ServerVersion;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.constant.ZeroDateOption;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.time.ZoneId;
import reactor.util.annotation.Nullable;

public final class ConnectionContext
implements CodecContext {
    private static final ServerVersion NONE_VERSION = ServerVersion.create(0, 0, 0);
    private volatile int connectionId = -1;
    private volatile ServerVersion serverVersion = NONE_VERSION;
    private final ZeroDateOption zeroDateOption;
    @Nullable
    private ZoneId serverZoneId;
    private volatile short serverStatuses = (short)2;
    private volatile int capabilities = 0;

    ConnectionContext(ZeroDateOption zeroDateOption, @Nullable ZoneId serverZoneId) {
        this.zeroDateOption = AssertUtils.requireNonNull(zeroDateOption, "zeroDateOption must not be null");
        this.serverZoneId = serverZoneId;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void init(int connectionId, ServerVersion version, int capabilities) {
        this.connectionId = connectionId;
        this.serverVersion = version;
        this.capabilities = capabilities;
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public CharCollation getClientCollation() {
        return CharCollation.clientCharCollation();
    }

    @Override
    public ZoneId getServerZoneId() {
        if (this.serverZoneId == null) {
            throw new IllegalStateException("Server timezone have not initialization");
        }
        return this.serverZoneId;
    }

    boolean shouldSetServerZoneId() {
        return this.serverZoneId == null;
    }

    void setServerZoneId(ZoneId serverZoneId) {
        if (this.serverZoneId != null) {
            throw new IllegalStateException("Server timezone have been initialized");
        }
        this.serverZoneId = serverZoneId;
    }

    @Override
    public ZeroDateOption getZeroDateOption() {
        return this.zeroDateOption;
    }

    public short getServerStatuses() {
        return this.serverStatuses;
    }

    public void setServerStatuses(short serverStatuses) {
        this.serverStatuses = serverStatuses;
    }

    public int getCapabilities() {
        return this.capabilities;
    }
}

