/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.guardrail;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.guardrail.OutputGuardrail;
import dev.langchain4j.guardrail.OutputGuardrailResult;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonExtractorOutputGuardrail<T>
implements OutputGuardrail {
    public static final String DEFAULT_REPROMPT_MESSAGE = "Invalid JSON";
    public static final String DEFAULT_REPROMPT_PROMPT = "Make sure you return a valid JSON object following the specified format";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonExtractorOutputGuardrail.class);
    private final ObjectMapper objectMapper;
    private Class<T> outputClass;
    private TypeReference<T> outputType;

    public JsonExtractorOutputGuardrail(ObjectMapper objectMapper, Class<T> outputClass) {
        this.objectMapper = ValidationUtils.ensureNotNull(objectMapper, "objectMapper");
        this.outputClass = ValidationUtils.ensureNotNull(outputClass, "outputClass");
    }

    public JsonExtractorOutputGuardrail(ObjectMapper objectMapper, TypeReference<T> outputType) {
        this.objectMapper = ValidationUtils.ensureNotNull(objectMapper, "objectMapper");
        this.outputType = ValidationUtils.ensureNotNull(outputType, "outputType");
    }

    public JsonExtractorOutputGuardrail(Class<T> outputClass) {
        this(new ObjectMapper(), outputClass);
    }

    public JsonExtractorOutputGuardrail(TypeReference<T> outputType) {
        this(new ObjectMapper(), outputType);
    }

    @Override
    public OutputGuardrailResult validate(AiMessage responseFromLLM) {
        String llmResponse = ValidationUtils.ensureNotNull(responseFromLLM, "responseFromLLM").text();
        LOGGER.debug("LLM output: {}", (Object)llmResponse);
        return this.deserialize(llmResponse).map(r -> this.successWith(llmResponse, r)).orElseGet(() -> {
            LOGGER.debug("LLM output contained invalid JSON. Attempting to trim non-JSON");
            String json = this.trimNonJson(llmResponse);
            LOGGER.debug("Attempting to deserialize trimmed JSON: {}", (Object)json);
            return this.deserialize(json).map(r -> this.successWith(json, r)).orElseGet(() -> this.invokeInvalidJson(responseFromLLM, json));
        });
    }

    protected String trimNonJson(String llmResponse) {
        int jsonMapStart = llmResponse.indexOf(123);
        int jsonListStart = llmResponse.indexOf(91);
        if (jsonMapStart < 0 && jsonListStart < 0) {
            return "";
        }
        boolean isJsonMap = jsonMapStart >= 0 && (jsonMapStart < jsonListStart || jsonListStart < 0);
        int jsonStart = isJsonMap ? jsonMapStart : jsonListStart;
        int jsonEnd = isJsonMap ? llmResponse.lastIndexOf(125) : llmResponse.lastIndexOf(93);
        return jsonEnd >= 0 && jsonStart < jsonEnd ? llmResponse.substring(jsonStart, jsonEnd + 1) : "";
    }

    protected OutputGuardrailResult invokeInvalidJson(AiMessage aiMessage, String json) {
        LOGGER.debug("Found invalid JSON for aiMessage = {} and json = {}", (Object)aiMessage, (Object)json);
        return this.reprompt(this.getInvalidJsonMessage(aiMessage, json), this.getInvalidJsonReprompt(aiMessage, json));
    }

    protected String getInvalidJsonMessage(AiMessage aiMessage, String json) {
        return DEFAULT_REPROMPT_MESSAGE;
    }

    protected String getInvalidJsonReprompt(AiMessage aiMessage, String json) {
        return DEFAULT_REPROMPT_PROMPT;
    }

    protected Optional<T> deserialize(String llmResponse) {
        try {
            Object obj = this.outputClass != null ? this.objectMapper.readValue(llmResponse, this.outputClass) : this.objectMapper.readValue(llmResponse, this.outputType);
            return Optional.ofNullable(obj);
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }
}

