/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse.graph;

import de.flapdoodle.graph.GraphAsDot;
import de.flapdoodle.graph.GraphBuilder;
import de.flapdoodle.graph.Loop;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.Transitions;
import de.flapdoodle.reverse.graph.HasSubGraph;
import de.flapdoodle.reverse.graph.StateVertex;
import de.flapdoodle.reverse.graph.TransitionVertex;
import de.flapdoodle.reverse.graph.Vertex;
import de.flapdoodle.reverse.types.TypeNames;
import de.flapdoodle.types.Either;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public abstract class TransitionGraph {
    private static final String JAVA_LANG_PACKAGE = "java.lang.";

    public static String edgeGraphAsDot(String label, Transitions transitions) {
        return TransitionGraph.edgeGraphAsDot(label, TransitionGraph.asGraph(transitions.transitions()));
    }

    public static DefaultDirectedGraph<Vertex, DefaultEdge> asGraph(List<? extends Transition<?>> all) {
        GraphBuilder builder = GraphBuilder.withDirectedGraph();
        all.forEach(edge -> {
            StateVertex destination = StateVertex.of(edge.destination());
            TransitionVertex transition = TransitionVertex.of(edge);
            builder.addVertex((Object)destination);
            builder.addVertex((Object)transition);
            builder.addEdge((Object)transition, (Object)destination);
            edge.sources().forEach(source -> {
                StateVertex s = StateVertex.of(source);
                builder.addVertex((Object)s);
                builder.addEdge((Object)s, (Object)transition);
            });
        });
        return (DefaultDirectedGraph)builder.build();
    }

    public static String edgeGraphAsDot(String label, DefaultDirectedGraph<Vertex, DefaultEdge> graph) {
        return TransitionGraph.edgeGraphAsDot(label, graph, Transition::asLabel, StateID::asLabel);
    }

    public static String edgeGraphAsDot(String label, DefaultDirectedGraph<Vertex, DefaultEdge> graph, Function<Transition<?>, String> transitionAsLabel, Function<StateID<?>, String> stateIdAsLabel) {
        Function<Vertex, String> vertexAsLabel = t -> {
            Either<StateVertex, TransitionVertex> stateOrTransition = Vertex.asEither(t);
            return (String)stateOrTransition.mapLeft(StateVertex::stateId).mapLeft(stateIdAsLabel::apply).mapRight(TransitionVertex::transition).mapRight(transitionAsLabel::apply).map(Function.identity(), Function.identity());
        };
        return GraphAsDot.builder(Vertex.asId()).subGraphIdSeparator("__").label(label).nodeAsLabel(vertexAsLabel).sortedBy(vertexAsLabel::apply).nodeAttributes(t -> {
            Either<StateVertex, TransitionVertex> stateOrTransition = Vertex.asEither(t);
            String shape = stateOrTransition.isLeft() ? "ellipse" : "rectangle";
            return TransitionGraph.asMap("shape", shape);
        }).subGraph(t -> {
            Transition<?> transition;
            if (t instanceof TransitionVertex && (transition = ((TransitionVertex)t).transition()) instanceof HasSubGraph) {
                return Optional.of(((HasSubGraph)((Object)transition)).subGraph());
            }
            return Optional.empty();
        }).build().asDot(graph);
    }

    private static Map<String, String> asMap(String ... keyValues) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("parameter not modulo of 2");
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            ret.put(keyValues[i], keyValues[i + 1]);
        }
        return ret;
    }

    public static String asMessage(List<? extends Loop<Vertex, DefaultEdge>> loops) {
        return loops.stream().map(TransitionGraph::asMessage).reduce((l, r) -> l + "\n" + r).orElse("");
    }

    private static String asMessage(Loop<Vertex, DefaultEdge> loop) {
        return loop.vertexSet().stream().map(TransitionGraph::asMessage).reduce((l, r) -> l + "->" + r).get();
    }

    public static String asMessage(Collection<StateID<?>> types) {
        return types.stream().map(TransitionGraph::asMessage).collect(Collectors.joining(", "));
    }

    private static String asMessage(Vertex type) {
        return (String)Vertex.asEither(type).mapLeft(StateVertex::stateId).mapLeft(TransitionGraph::asMessage).mapRight(TransitionVertex::transition).mapRight(TransitionGraph::asMessage).map(Function.identity(), Function.identity());
    }

    public static String asMessage(StateID<?> type) {
        return "State(" + (type.name().isEmpty() ? TransitionGraph.typeAsMessage(type.type()) : type.name() + ":" + TransitionGraph.typeAsMessage(type.type())) + ")";
    }

    private static String asMessage(Transition<?> transition) {
        return transition.toString();
    }

    private static String typeAsMessage(TypeInfo<?> typeInfo) {
        return TypeNames.typeName(typeInfo);
    }
}

