/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import de.flapdoodle.types.ImmutableNone;
import de.flapdoodle.types.ImmutableSome;
import de.flapdoodle.types.Nullable;
import java.util.function.Function;
import org.immutables.value.Value;

public abstract class Maybe<T> {
    public abstract boolean hasSome();

    @Nullable
    public abstract T get();

    public abstract <R> Maybe<R> map(Function<T, R> var1);

    public T getOrThrow(IllegalArgumentException e) {
        if (!this.hasSome()) {
            throw e;
        }
        return this.get();
    }

    public static <T> None<T> none() {
        return ImmutableNone.of();
    }

    public static <T> Some<T> some(@Nullable T value) {
        return ImmutableSome.of(value);
    }

    @Value.Immutable(singleton=true)
    public static abstract class None<T>
    extends Maybe<T> {
        @Override
        @Value.Auxiliary
        public boolean hasSome() {
            return false;
        }

        @Override
        public T get() {
            throw new IllegalArgumentException("is none");
        }

        @Override
        public <R> Maybe<R> map(Function<T, R> mapping) {
            return Maybe.none();
        }
    }

    @Value.Immutable
    public static abstract class Some<T>
    extends Maybe<T> {
        @Nullable
        @Value.Parameter
        protected abstract T value();

        @Override
        @Value.Auxiliary
        public boolean hasSome() {
            return true;
        }

        @Override
        public T get() {
            return this.value();
        }

        @Override
        public <R> Maybe<R> map(Function<T, R> mapping) {
            return Maybe.some(mapping.apply(this.value()));
        }
    }
}

