/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.types;

import de.flapdoodle.embed.process.types.Percent;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutablePercent
extends Percent {
    private final int value;

    private ImmutablePercent(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return this.value;
    }

    public final ImmutablePercent withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return ImmutablePercent.validate(new ImmutablePercent(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePercent && this.equalsByValue((ImmutablePercent)another);
    }

    private boolean equalsByValue(ImmutablePercent another) {
        return this.value == another.value;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value;
        return h;
    }

    public String toString() {
        return "Percent{value=" + this.value + "}";
    }

    public static ImmutablePercent of(int value) {
        return ImmutablePercent.validate(new ImmutablePercent(value));
    }

    private static ImmutablePercent validate(ImmutablePercent instance) {
        instance.check();
        return instance;
    }

    public static ImmutablePercent copyOf(Percent instance) {
        if (instance instanceof ImmutablePercent) {
            return (ImmutablePercent)instance;
        }
        return ImmutablePercent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private int value;

        private Builder() {
        }

        public final Builder from(Percent instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            return this;
        }

        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePercent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutablePercent.validate(new ImmutablePercent(this.value));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Percent, some of required attributes are not set " + attributes;
        }
    }
}

