/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config;

import de.flapdoodle.embed.process.config.DownloadConfig;
import de.flapdoodle.embed.process.config.TimeoutConfig;
import de.flapdoodle.net.ProxyFactory;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableDownloadConfig
implements DownloadConfig {
    private final ProxyFactory proxyFactory;
    private final String userAgent;
    private final String authorization;
    private final TimeoutConfig timeoutConfig;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDownloadConfig(Builder builder) {
        this.proxyFactory = builder.proxyFactory;
        this.authorization = builder.authorization;
        if (builder.userAgent != null) {
            this.initShim.userAgent(builder.userAgent);
        }
        if (builder.timeoutConfig != null) {
            this.initShim.timeoutConfig(builder.timeoutConfig);
        }
        this.userAgent = this.initShim.getUserAgent();
        this.timeoutConfig = this.initShim.getTimeoutConfig();
        this.initShim = null;
    }

    private ImmutableDownloadConfig(ProxyFactory proxyFactory, String userAgent, String authorization, TimeoutConfig timeoutConfig) {
        this.proxyFactory = proxyFactory;
        this.userAgent = userAgent;
        this.authorization = authorization;
        this.timeoutConfig = timeoutConfig;
        this.initShim = null;
    }

    private String getUserAgentInitialize() {
        return DownloadConfig.super.getUserAgent();
    }

    private TimeoutConfig getTimeoutConfigInitialize() {
        return DownloadConfig.super.getTimeoutConfig();
    }

    @Override
    public Optional<ProxyFactory> proxyFactory() {
        return Optional.ofNullable(this.proxyFactory);
    }

    @Override
    public String getUserAgent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUserAgent() : this.userAgent;
    }

    @Override
    @Deprecated
    public Optional<String> getAuthorization() {
        return Optional.ofNullable(this.authorization);
    }

    @Override
    public TimeoutConfig getTimeoutConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTimeoutConfig() : this.timeoutConfig;
    }

    public final ImmutableDownloadConfig withProxyFactory(ProxyFactory value) {
        ProxyFactory newValue = Objects.requireNonNull(value, "proxyFactory");
        if (this.proxyFactory == newValue) {
            return this;
        }
        return new ImmutableDownloadConfig(newValue, this.userAgent, this.authorization, this.timeoutConfig);
    }

    public final ImmutableDownloadConfig withProxyFactory(Optional<? extends ProxyFactory> optional) {
        ProxyFactory value = optional.orElse(null);
        if (this.proxyFactory == value) {
            return this;
        }
        return new ImmutableDownloadConfig(value, this.userAgent, this.authorization, this.timeoutConfig);
    }

    public final ImmutableDownloadConfig withUserAgent(String value) {
        String newValue = Objects.requireNonNull(value, "userAgent");
        if (this.userAgent.equals(newValue)) {
            return this;
        }
        return new ImmutableDownloadConfig(this.proxyFactory, newValue, this.authorization, this.timeoutConfig);
    }

    @Deprecated
    public final ImmutableDownloadConfig withAuthorization(String value) {
        String newValue = Objects.requireNonNull(value, "authorization");
        if (Objects.equals(this.authorization, newValue)) {
            return this;
        }
        return new ImmutableDownloadConfig(this.proxyFactory, this.userAgent, newValue, this.timeoutConfig);
    }

    @Deprecated
    public final ImmutableDownloadConfig withAuthorization(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.authorization, value)) {
            return this;
        }
        return new ImmutableDownloadConfig(this.proxyFactory, this.userAgent, value, this.timeoutConfig);
    }

    public final ImmutableDownloadConfig withTimeoutConfig(TimeoutConfig value) {
        if (this.timeoutConfig == value) {
            return this;
        }
        TimeoutConfig newValue = Objects.requireNonNull(value, "timeoutConfig");
        return new ImmutableDownloadConfig(this.proxyFactory, this.userAgent, this.authorization, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDownloadConfig && this.equalsByValue((ImmutableDownloadConfig)another);
    }

    private boolean equalsByValue(ImmutableDownloadConfig another) {
        return Objects.equals(this.proxyFactory, another.proxyFactory) && this.userAgent.equals(another.userAgent) && Objects.equals(this.authorization, another.authorization) && this.timeoutConfig.equals(another.timeoutConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.proxyFactory);
        h += (h << 5) + this.userAgent.hashCode();
        h += (h << 5) + Objects.hashCode(this.authorization);
        h += (h << 5) + this.timeoutConfig.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DownloadConfig{");
        if (this.proxyFactory != null) {
            builder.append("proxyFactory=").append(this.proxyFactory);
        }
        if (builder.length() > 15) {
            builder.append(", ");
        }
        builder.append("userAgent=").append(this.userAgent);
        if (this.authorization != null) {
            builder.append(", ");
            builder.append("authorization=").append(this.authorization);
        }
        builder.append(", ");
        builder.append("timeoutConfig=").append(this.timeoutConfig);
        return builder.append("}").toString();
    }

    public static ImmutableDownloadConfig copyOf(DownloadConfig instance) {
        if (instance instanceof ImmutableDownloadConfig) {
            return (ImmutableDownloadConfig)instance;
        }
        return ImmutableDownloadConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ProxyFactory proxyFactory;
        private String userAgent;
        private String authorization;
        private TimeoutConfig timeoutConfig;

        private Builder() {
        }

        public final Builder from(DownloadConfig instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<ProxyFactory> proxyFactoryOptional = instance.proxyFactory();
            if (proxyFactoryOptional.isPresent()) {
                this.proxyFactory(proxyFactoryOptional);
            }
            this.userAgent(instance.getUserAgent());
            Optional<String> authorizationOptional = instance.getAuthorization();
            if (authorizationOptional.isPresent()) {
                this.authorization(authorizationOptional);
            }
            this.timeoutConfig(instance.getTimeoutConfig());
            return this;
        }

        public final Builder proxyFactory(ProxyFactory proxyFactory) {
            this.proxyFactory = Objects.requireNonNull(proxyFactory, "proxyFactory");
            return this;
        }

        public final Builder proxyFactory(Optional<? extends ProxyFactory> proxyFactory) {
            this.proxyFactory = proxyFactory.orElse(null);
            return this;
        }

        public final Builder userAgent(String userAgent) {
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
            return this;
        }

        @Deprecated
        public final Builder authorization(String authorization) {
            this.authorization = Objects.requireNonNull(authorization, "authorization");
            return this;
        }

        @Deprecated
        public final Builder authorization(Optional<String> authorization) {
            this.authorization = authorization.orElse(null);
            return this;
        }

        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = Objects.requireNonNull(timeoutConfig, "timeoutConfig");
            return this;
        }

        public ImmutableDownloadConfig build() {
            return new ImmutableDownloadConfig(this);
        }
    }

    private final class InitShim {
        private byte userAgentBuildStage = 0;
        private String userAgent;
        private byte timeoutConfigBuildStage = 0;
        private TimeoutConfig timeoutConfig;

        private InitShim() {
        }

        String getUserAgent() {
            if (this.userAgentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userAgentBuildStage == 0) {
                this.userAgentBuildStage = (byte)-1;
                this.userAgent = Objects.requireNonNull(ImmutableDownloadConfig.this.getUserAgentInitialize(), "userAgent");
                this.userAgentBuildStage = 1;
            }
            return this.userAgent;
        }

        void userAgent(String userAgent) {
            this.userAgent = userAgent;
            this.userAgentBuildStage = 1;
        }

        TimeoutConfig getTimeoutConfig() {
            if (this.timeoutConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timeoutConfigBuildStage == 0) {
                this.timeoutConfigBuildStage = (byte)-1;
                this.timeoutConfig = Objects.requireNonNull(ImmutableDownloadConfig.this.getTimeoutConfigInitialize(), "timeoutConfig");
                this.timeoutConfigBuildStage = 1;
            }
            return this.timeoutConfig;
        }

        void timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            this.timeoutConfigBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.userAgentBuildStage == -1) {
                attributes.add("userAgent");
            }
            if (this.timeoutConfigBuildStage == -1) {
                attributes.add("timeoutConfig");
            }
            return "Cannot build DownloadConfig, attribute initializers form cycle " + attributes;
        }
    }
}

