/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.archives;

import de.flapdoodle.embed.process.archives.ArchiveStream;
import de.flapdoodle.embed.process.archives.ExtractFileSet;
import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.archives.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.io.Files;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveEntry;

public abstract class AbstractExtractFileSet
implements ExtractFileSet {
    protected abstract ArchiveStream archiveStream(Path var1) throws IOException;

    private ArchiveStream archiveStreamWithExceptionHint(Path source) throws IOException {
        try {
            return this.archiveStream(source);
        }
        catch (IOException iox) {
            throw new IOException("You should check if the file is corrupt: " + source.toAbsolutePath(), iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractedFileSet extract(Path destination, Path archive, FileSet filesToExtract) throws IOException {
        ImmutableExtractedFileSet.Builder builder = ExtractedFileSet.builder(destination);
        Tracker tracker = new Tracker(filesToExtract);
        try (ArchiveStream wrapper = this.archiveStreamWithExceptionHint(archive);){
            ArchiveEntry archiveEntry;
            while ((archiveEntry = wrapper.getNextEntry()) != null) {
                Optional<FileSet.Entry> matchingEntry = tracker.find(archiveEntry);
                if (matchingEntry.isPresent()) {
                    if (wrapper.canReadEntryData(archiveEntry)) {
                        long size = archiveEntry.getSize();
                        FileType type = matchingEntry.get().type();
                        Path dest = destination.resolve(matchingEntry.get().destination());
                        Files.write(wrapper.asStream(archiveEntry), size, dest);
                        if (type == FileType.Executable) {
                            builder.executable(dest);
                            if (!dest.toFile().setExecutable(true)) {
                                throw new IllegalArgumentException("could not set executable flag on " + dest);
                            }
                        } else {
                            builder.addLibraryFiles(dest);
                        }
                    } else {
                        throw new IllegalArgumentException("could not read " + archiveEntry);
                    }
                }
                if (!tracker.nothingLeft()) continue;
                break;
            }
        }
        return builder.build();
    }

    static Optional<FileSet.Entry> findMatchingEntry(List<FileSet.Entry> files, ArchiveEntry entry) {
        return files.stream().filter(e -> e.matchingPattern().matcher(entry.getName()).matches()).findFirst();
    }

    static class Tracker {
        private final ArrayList<FileSet.Entry> files;

        public Tracker(FileSet fileSet) {
            this.files = new ArrayList<FileSet.Entry>(fileSet.entries());
        }

        public boolean nothingLeft() {
            return this.files.isEmpty();
        }

        public Optional<FileSet.Entry> find(ArchiveEntry entry) {
            Optional<FileSet.Entry> ret = Optional.empty();
            if (!entry.isDirectory() && (ret = AbstractExtractFileSet.findMatchingEntry(this.files, entry)).isPresent()) {
                this.files.remove(ret.get());
            }
            return ret;
        }
    }
}

