/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.StreamProcessor;
import java.util.HashSet;
import java.util.Set;

public class LogWatchStreamProcessor
implements StreamProcessor {
    private final StringBuilder output = new StringBuilder();
    private final String success;
    private final Set<String> failures;
    private boolean initWithSuccess = false;
    private String failureFound = null;
    private final StreamProcessor destination;

    public LogWatchStreamProcessor(String success, Set<String> failures, StreamProcessor destination) {
        this.success = success;
        this.failures = new HashSet<String>(failures);
        this.destination = destination;
    }

    @Override
    public void process(String block) {
        this.destination.process(block);
        this.output.append((CharSequence)block);
        if (this.output.indexOf(this.success) != -1) {
            this.gotResult(true, null);
        } else {
            for (String failure : this.failures) {
                int failureIndex = this.output.indexOf(failure);
                if (failureIndex == -1) continue;
                this.gotResult(false, this.output.substring(failureIndex));
            }
        }
    }

    @Override
    public void onProcessed() {
        this.gotResult(false, "<EOF>");
    }

    private synchronized void gotResult(boolean success, String message) {
        this.initWithSuccess = success;
        this.failureFound = message;
        this.notify();
    }

    public synchronized void waitForResult(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isInitWithSuccess() {
        return this.initWithSuccess;
    }

    public String getFailureFound() {
        return this.failureFound;
    }

    public String getOutput() {
        return this.output.toString();
    }
}

