/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.config.store.DistributionDownloadPath;
import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.PackageResolver;
import de.flapdoodle.embed.process.config.store.ProxyFactory;
import de.flapdoodle.embed.process.config.store.TimeoutConfig;
import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="DownloadConfig", generator="Immutables")
public final class ImmutableDownloadConfig
implements DownloadConfig {
    private final DistributionDownloadPath downloadPath;
    private final ProgressListener progressListener;
    private final Directory artifactStorePath;
    private final TempNaming fileNaming;
    private final String downloadPrefix;
    private final String userAgent;
    private final String authorization;
    private final PackageResolver packageResolver;
    private final TimeoutConfig timeoutConfig;
    private final ProxyFactory proxyFactory;

    private ImmutableDownloadConfig(Builder builder) {
        this.downloadPath = builder.downloadPath;
        this.progressListener = builder.progressListener;
        this.artifactStorePath = builder.artifactStorePath;
        this.fileNaming = builder.fileNaming;
        this.downloadPrefix = builder.downloadPrefix;
        this.userAgent = builder.userAgent;
        this.authorization = builder.authorization;
        this.packageResolver = builder.packageResolver;
        this.proxyFactory = builder.proxyFactory;
        this.timeoutConfig = builder.timeoutConfig != null ? builder.timeoutConfig : Objects.requireNonNull(DownloadConfig.super.getTimeoutConfig(), "timeoutConfig");
    }

    private ImmutableDownloadConfig(DistributionDownloadPath downloadPath, ProgressListener progressListener, Directory artifactStorePath, TempNaming fileNaming, String downloadPrefix, String userAgent, String authorization, PackageResolver packageResolver, TimeoutConfig timeoutConfig, ProxyFactory proxyFactory) {
        this.downloadPath = downloadPath;
        this.progressListener = progressListener;
        this.artifactStorePath = artifactStorePath;
        this.fileNaming = fileNaming;
        this.downloadPrefix = downloadPrefix;
        this.userAgent = userAgent;
        this.authorization = authorization;
        this.packageResolver = packageResolver;
        this.timeoutConfig = timeoutConfig;
        this.proxyFactory = proxyFactory;
    }

    @Override
    public DistributionDownloadPath getDownloadPath() {
        return this.downloadPath;
    }

    @Override
    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public Directory getArtifactStorePath() {
        return this.artifactStorePath;
    }

    @Override
    public TempNaming getFileNaming() {
        return this.fileNaming;
    }

    @Override
    public String getDownloadPrefix() {
        return this.downloadPrefix;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public Optional<String> getAuthorization() {
        return Optional.ofNullable(this.authorization);
    }

    @Override
    public PackageResolver getPackageResolver() {
        return this.packageResolver;
    }

    @Override
    public TimeoutConfig getTimeoutConfig() {
        return this.timeoutConfig;
    }

    @Override
    public Optional<ProxyFactory> proxyFactory() {
        return Optional.ofNullable(this.proxyFactory);
    }

    public final ImmutableDownloadConfig withDownloadPath(DistributionDownloadPath value) {
        if (this.downloadPath == value) {
            return this;
        }
        DistributionDownloadPath newValue = Objects.requireNonNull(value, "downloadPath");
        return new ImmutableDownloadConfig(newValue, this.progressListener, this.artifactStorePath, this.fileNaming, this.downloadPrefix, this.userAgent, this.authorization, this.packageResolver, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withProgressListener(ProgressListener value) {
        if (this.progressListener == value) {
            return this;
        }
        ProgressListener newValue = Objects.requireNonNull(value, "progressListener");
        return new ImmutableDownloadConfig(this.downloadPath, newValue, this.artifactStorePath, this.fileNaming, this.downloadPrefix, this.userAgent, this.authorization, this.packageResolver, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withArtifactStorePath(Directory value) {
        if (this.artifactStorePath == value) {
            return this;
        }
        Directory newValue = Objects.requireNonNull(value, "artifactStorePath");
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, newValue, this.fileNaming, this.downloadPrefix, this.userAgent, this.authorization, this.packageResolver, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withFileNaming(TempNaming value) {
        if (this.fileNaming == value) {
            return this;
        }
        TempNaming newValue = Objects.requireNonNull(value, "fileNaming");
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, newValue, this.downloadPrefix, this.userAgent, this.authorization, this.packageResolver, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withDownloadPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "downloadPrefix");
        if (this.downloadPrefix.equals(newValue)) {
            return this;
        }
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, this.fileNaming, newValue, this.userAgent, this.authorization, this.packageResolver, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withUserAgent(String value) {
        String newValue = Objects.requireNonNull(value, "userAgent");
        if (this.userAgent.equals(newValue)) {
            return this;
        }
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, this.fileNaming, this.downloadPrefix, newValue, this.authorization, this.packageResolver, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withAuthorization(String value) {
        String newValue = Objects.requireNonNull(value, "authorization");
        if (Objects.equals(this.authorization, newValue)) {
            return this;
        }
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, this.fileNaming, this.downloadPrefix, this.userAgent, newValue, this.packageResolver, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withAuthorization(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.authorization, value)) {
            return this;
        }
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, this.fileNaming, this.downloadPrefix, this.userAgent, value, this.packageResolver, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withPackageResolver(PackageResolver value) {
        if (this.packageResolver == value) {
            return this;
        }
        PackageResolver newValue = Objects.requireNonNull(value, "packageResolver");
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, this.fileNaming, this.downloadPrefix, this.userAgent, this.authorization, newValue, this.timeoutConfig, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withTimeoutConfig(TimeoutConfig value) {
        if (this.timeoutConfig == value) {
            return this;
        }
        TimeoutConfig newValue = Objects.requireNonNull(value, "timeoutConfig");
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, this.fileNaming, this.downloadPrefix, this.userAgent, this.authorization, this.packageResolver, newValue, this.proxyFactory);
    }

    public final ImmutableDownloadConfig withProxyFactory(ProxyFactory value) {
        ProxyFactory newValue = Objects.requireNonNull(value, "proxyFactory");
        if (this.proxyFactory == newValue) {
            return this;
        }
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, this.fileNaming, this.downloadPrefix, this.userAgent, this.authorization, this.packageResolver, this.timeoutConfig, newValue);
    }

    public final ImmutableDownloadConfig withProxyFactory(Optional<? extends ProxyFactory> optional) {
        ProxyFactory value = optional.orElse(null);
        if (this.proxyFactory == value) {
            return this;
        }
        return new ImmutableDownloadConfig(this.downloadPath, this.progressListener, this.artifactStorePath, this.fileNaming, this.downloadPrefix, this.userAgent, this.authorization, this.packageResolver, this.timeoutConfig, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDownloadConfig && this.equalTo((ImmutableDownloadConfig)another);
    }

    private boolean equalTo(ImmutableDownloadConfig another) {
        return this.downloadPath.equals(another.downloadPath) && this.progressListener.equals(another.progressListener) && this.artifactStorePath.equals(another.artifactStorePath) && this.fileNaming.equals(another.fileNaming) && this.downloadPrefix.equals(another.downloadPrefix) && this.userAgent.equals(another.userAgent) && Objects.equals(this.authorization, another.authorization) && this.packageResolver.equals(another.packageResolver) && this.timeoutConfig.equals(another.timeoutConfig) && Objects.equals(this.proxyFactory, another.proxyFactory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.downloadPath.hashCode();
        h += (h << 5) + this.progressListener.hashCode();
        h += (h << 5) + this.artifactStorePath.hashCode();
        h += (h << 5) + this.fileNaming.hashCode();
        h += (h << 5) + this.downloadPrefix.hashCode();
        h += (h << 5) + this.userAgent.hashCode();
        h += (h << 5) + Objects.hashCode(this.authorization);
        h += (h << 5) + this.packageResolver.hashCode();
        h += (h << 5) + this.timeoutConfig.hashCode();
        h += (h << 5) + Objects.hashCode(this.proxyFactory);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DownloadConfig{");
        builder.append("downloadPath=").append(this.downloadPath);
        builder.append(", ");
        builder.append("progressListener=").append(this.progressListener);
        builder.append(", ");
        builder.append("artifactStorePath=").append(this.artifactStorePath);
        builder.append(", ");
        builder.append("fileNaming=").append(this.fileNaming);
        builder.append(", ");
        builder.append("downloadPrefix=").append(this.downloadPrefix);
        builder.append(", ");
        builder.append("userAgent=").append(this.userAgent);
        if (this.authorization != null) {
            builder.append(", ");
            builder.append("authorization=").append(this.authorization);
        }
        builder.append(", ");
        builder.append("packageResolver=").append(this.packageResolver);
        builder.append(", ");
        builder.append("timeoutConfig=").append(this.timeoutConfig);
        if (this.proxyFactory != null) {
            builder.append(", ");
            builder.append("proxyFactory=").append(this.proxyFactory);
        }
        return builder.append("}").toString();
    }

    public static ImmutableDownloadConfig copyOf(DownloadConfig instance) {
        if (instance instanceof ImmutableDownloadConfig) {
            return (ImmutableDownloadConfig)instance;
        }
        return ImmutableDownloadConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DownloadConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DOWNLOAD_PATH = 1L;
        private static final long INIT_BIT_PROGRESS_LISTENER = 2L;
        private static final long INIT_BIT_ARTIFACT_STORE_PATH = 4L;
        private static final long INIT_BIT_FILE_NAMING = 8L;
        private static final long INIT_BIT_DOWNLOAD_PREFIX = 16L;
        private static final long INIT_BIT_USER_AGENT = 32L;
        private static final long INIT_BIT_PACKAGE_RESOLVER = 64L;
        private long initBits = 127L;
        private DistributionDownloadPath downloadPath;
        private ProgressListener progressListener;
        private Directory artifactStorePath;
        private TempNaming fileNaming;
        private String downloadPrefix;
        private String userAgent;
        private String authorization;
        private PackageResolver packageResolver;
        private TimeoutConfig timeoutConfig;
        private ProxyFactory proxyFactory;

        private Builder() {
        }

        public final Builder from(DownloadConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.downloadPath(instance.getDownloadPath());
            this.progressListener(instance.getProgressListener());
            this.artifactStorePath(instance.getArtifactStorePath());
            this.fileNaming(instance.getFileNaming());
            this.downloadPrefix(instance.getDownloadPrefix());
            this.userAgent(instance.getUserAgent());
            Optional<String> authorizationOptional = instance.getAuthorization();
            if (authorizationOptional.isPresent()) {
                this.authorization(authorizationOptional);
            }
            this.packageResolver(instance.getPackageResolver());
            this.timeoutConfig(instance.getTimeoutConfig());
            Optional<ProxyFactory> proxyFactoryOptional = instance.proxyFactory();
            if (proxyFactoryOptional.isPresent()) {
                this.proxyFactory(proxyFactoryOptional);
            }
            return this;
        }

        public final Builder downloadPath(DistributionDownloadPath downloadPath) {
            this.downloadPath = Objects.requireNonNull(downloadPath, "downloadPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder progressListener(ProgressListener progressListener) {
            this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder artifactStorePath(Directory artifactStorePath) {
            this.artifactStorePath = Objects.requireNonNull(artifactStorePath, "artifactStorePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder fileNaming(TempNaming fileNaming) {
            this.fileNaming = Objects.requireNonNull(fileNaming, "fileNaming");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder downloadPrefix(String downloadPrefix) {
            this.downloadPrefix = Objects.requireNonNull(downloadPrefix, "downloadPrefix");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder userAgent(String userAgent) {
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder authorization(String authorization) {
            this.authorization = Objects.requireNonNull(authorization, "authorization");
            return this;
        }

        public final Builder authorization(Optional<String> authorization) {
            this.authorization = authorization.orElse(null);
            return this;
        }

        public final Builder packageResolver(PackageResolver packageResolver) {
            this.packageResolver = Objects.requireNonNull(packageResolver, "packageResolver");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = Objects.requireNonNull(timeoutConfig, "timeoutConfig");
            return this;
        }

        public final Builder proxyFactory(ProxyFactory proxyFactory) {
            this.proxyFactory = Objects.requireNonNull(proxyFactory, "proxyFactory");
            return this;
        }

        public final Builder proxyFactory(Optional<? extends ProxyFactory> proxyFactory) {
            this.proxyFactory = proxyFactory.orElse(null);
            return this;
        }

        public ImmutableDownloadConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDownloadConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("downloadPath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("progressListener");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("artifactStorePath");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("fileNaming");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("downloadPrefix");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("userAgent");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("packageResolver");
            }
            return "Cannot build DownloadConfig, some of required attributes are not set " + attributes;
        }
    }
}

