/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.builder;

import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AbstractEmbeddedBuilder<B> {
    Map<TypedProperty<?>, Object> propertyMap = new HashMap();
    Set<TypedProperty<?>> propertyHadDefaultValueMap = new HashSet();

    protected <T> IProperty<T> property(TypedProperty<T> typedProperty) {
        return new Property<T>(typedProperty);
    }

    protected <T> T setDefault(TypedProperty<T> property, T value) {
        T old = this.set(property, value);
        if (!this.propertyHadDefaultValueMap.add(property)) {
            throw new RuntimeException("" + property + " is already set with default value");
        }
        return old;
    }

    protected <T> T overwriteDefault(TypedProperty<T> property, T value) {
        T old = this.set(property, value);
        this.propertyHadDefaultValueMap.add(property);
        return old;
    }

    protected <T> T set(TypedProperty<T> property, T value) {
        Object old = this.propertyMap.put(property, value);
        boolean onlyDefaultValueWasSet = this.propertyHadDefaultValueMap.remove(property);
        if (old != null && !onlyDefaultValueWasSet) {
            throw new RuntimeException("" + property + " already set to " + old);
        }
        return (T)old;
    }

    protected <T> T get(TypedProperty<T> property) {
        Object ret = this.propertyMap.get(property);
        if (ret == null) {
            throw new RuntimeException("" + property + " not set");
        }
        return (T)ret;
    }

    protected <T> T get(TypedProperty<T> property, T defaultValue) {
        Object ret = this.propertyMap.get(property);
        return (T)(ret != null ? ret : defaultValue);
    }

    private class Property<T>
    implements IProperty<T> {
        private final TypedProperty<T> typedProperty;

        public Property(TypedProperty<T> typedProperty) {
            this.typedProperty = typedProperty;
        }

        @Override
        public T set(T value) {
            return AbstractEmbeddedBuilder.this.set(this.typedProperty, value);
        }

        @Override
        public T setDefault(T value) {
            return AbstractEmbeddedBuilder.this.setDefault(this.typedProperty, value);
        }

        @Override
        public T overwriteDefault(T value) {
            return AbstractEmbeddedBuilder.this.overwriteDefault(this.typedProperty, value);
        }

        @Override
        public T get() {
            return AbstractEmbeddedBuilder.this.get(this.typedProperty);
        }
    }
}

